/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.WorkerPool;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class Worker
extends Thread {
    private static int nextWorkerNumber = 0;
    private volatile InternalJob currentJob;
    private final WorkerPool pool;

    public Worker(WorkerPool pool) {
        super("Worker-" + nextWorkerNumber++);
        this.pool = pool;
    }

    public Job currentJob() {
        return (Job)this.currentJob;
    }

    private IStatus handleException(InternalJob job, Throwable t) {
        String message = Policy.bind("jobs.internalError", job.getName());
        return new Status(4, "org.eclipse.core.runtime", 2, message, t);
    }

    private void log(IStatus result) {
        block2: {
            try {
                InternalPlatform.getDefault().log(result);
            }
            catch (RuntimeException e) {
                Throwable t = result.getException();
                if (t == null) break block2;
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setPriority(5);
        try {
            try {
                while ((this.currentJob = this.pool.startJob(this)) != null) {
                    Object var4_7;
                    if (this.currentJob == null) {
                        Object var6_8 = null;
                        this.currentJob = null;
                        this.pool.endWorker(this);
                        return;
                    }
                    this.currentJob.setThread(this);
                    IStatus result = Status.OK_STATUS;
                    try {
                        try {
                            result = this.currentJob.run(this.currentJob.getProgressMonitor());
                        }
                        catch (OperationCanceledException e) {
                            result = Status.CANCEL_STATUS;
                            var4_7 = null;
                            Thread.interrupted();
                            if (result == null) {
                                result = this.handleException(this.currentJob(), new NullPointerException());
                            }
                            this.pool.endJob(this.currentJob, result);
                            if ((result.getSeverity() & 6) != 0) {
                                this.log(result);
                            }
                            this.currentJob = null;
                            continue;
                        }
                        catch (Exception e) {
                            result = this.handleException(this.currentJob, e);
                            var4_7 = null;
                            Thread.interrupted();
                            if (result == null) {
                                result = this.handleException(this.currentJob(), new NullPointerException());
                            }
                            this.pool.endJob(this.currentJob, result);
                            if ((result.getSeverity() & 6) != 0) {
                                this.log(result);
                            }
                            this.currentJob = null;
                            continue;
                        }
                        catch (Error e) {
                            result = this.handleException(this.currentJob, e);
                            var4_7 = null;
                            Thread.interrupted();
                            if (result == null) {
                                result = this.handleException(this.currentJob(), new NullPointerException());
                            }
                            this.pool.endJob(this.currentJob, result);
                            if ((result.getSeverity() & 6) != 0) {
                                this.log(result);
                            }
                            this.currentJob = null;
                            continue;
                        }
                        var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        Thread.interrupted();
                        if (result == null) {
                            result = this.handleException(this.currentJob(), new NullPointerException());
                        }
                        this.pool.endJob(this.currentJob, result);
                        if ((result.getSeverity() & 6) != 0) {
                            this.log(result);
                        }
                        this.currentJob = null;
                        throw throwable;
                    }
                    Thread.interrupted();
                    if (result == null) {
                        result = this.handleException(this.currentJob(), new NullPointerException());
                    }
                    this.pool.endJob(this.currentJob, result);
                    if ((result.getSeverity() & 6) != 0) {
                        this.log(result);
                    }
                    this.currentJob = null;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Object var6_10 = null;
                this.currentJob = null;
                this.pool.endWorker(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.currentJob = null;
            this.pool.endWorker(this);
            throw throwable;
        }
        Object var6_9 = null;
        this.currentJob = null;
        this.pool.endWorker(this);
    }
}

