/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

public final class BinarySignatureDescriber
implements IContentDescriber,
IExecutableExtension {
    private static final String SIGNATURE = "signature";
    private static final String OFFSET = "offset";
    private static final Object REQUIRED = "required";
    private byte[] signature;
    private int offset;
    private boolean required = true;
    static /* synthetic */ Class class$org$eclipse$core$runtime$content$XMLRootElementContentDescriber;
    static /* synthetic */ Class class$org$eclipse$core$runtime$content$BinarySignatureDescriber;

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int notValid;
        byte[] buffer = new byte[this.signature.length];
        int n = notValid = this.required ? 0 : 1;
        if (contents.skip(this.offset) < (long)this.offset) {
            return notValid;
        }
        if (contents.read(buffer) != buffer.length) {
            return notValid;
        }
        for (int i = 0; i < this.signature.length; ++i) {
            if (this.signature[i] == buffer[i]) continue;
            return notValid;
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            if (data instanceof String) {
                this.signature = this.parseSignature((String)data);
            } else if (data instanceof Hashtable) {
                Hashtable parameters = (Hashtable)data;
                if (!parameters.containsKey(SIGNATURE)) {
                    String message = Policy.bind("content.badInitializationData", (class$org$eclipse$core$runtime$content$XMLRootElementContentDescriber == null ? (class$org$eclipse$core$runtime$content$XMLRootElementContentDescriber = BinarySignatureDescriber.class$("org.eclipse.core.runtime.content.XMLRootElementContentDescriber")) : class$org$eclipse$core$runtime$content$XMLRootElementContentDescriber).getName());
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 0, message, null));
                }
                this.signature = this.parseSignature((String)parameters.get(SIGNATURE));
                if (parameters.containsKey(OFFSET)) {
                    this.offset = Integer.parseInt((String)parameters.get(OFFSET));
                }
                if (parameters.containsKey(REQUIRED)) {
                    this.required = Boolean.valueOf((String)parameters.get(REQUIRED));
                }
            }
        }
        catch (NumberFormatException nfe) {
            String message = Policy.bind("content.badInitializationData", (class$org$eclipse$core$runtime$content$BinarySignatureDescriber == null ? (class$org$eclipse$core$runtime$content$BinarySignatureDescriber = BinarySignatureDescriber.class$("org.eclipse.core.runtime.content.BinarySignatureDescriber")) : class$org$eclipse$core$runtime$content$BinarySignatureDescriber).getName());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 0, message, nfe));
        }
    }

    private byte[] parseSignature(String data) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(data, " \t\n\r\f,");
        while (tokenizer.hasMoreTokens()) {
            bytes.add(new Byte((byte)Integer.parseInt(tokenizer.nextToken().trim(), 16)));
        }
        byte[] signature = new byte[bytes.size()];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = (Byte)bytes.get(i);
        }
        return signature;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

