/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.connection;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IServerConnection;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSAuthenticationException;
import org.eclipse.team.internal.ccvs.core.connection.Connection;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.core.streams.PollingInputStream;
import org.eclipse.team.internal.core.streams.PollingOutputStream;
import org.eclipse.team.internal.core.streams.TimeoutOutputStream;

public class PServerConnection
implements IServerConnection {
    public static final char NEWLINE = '\n';
    private static final int DEFAULT_PORT = 2401;
    private static final char ERROR_CHAR = 'E';
    private static final String ERROR_MESSAGE = "error 0";
    private static final String NO_SUCH_USER = "no such user";
    private static final char[] SCRAMBLING_TABLE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', 'r', 'x', '5', 'O', '`', 'm', 'H', 'l', 'F', '@', 'L', 'C', 't', 'J', 'D', 'W', 'o', '4', 'K', 'w', '1', '\"', 'R', 'Q', '_', 'A', 'p', 'V', 'v', 'n', 'z', 'i', ')', '9', 'S', '+', '.', 'f', '(', 'Y', '&', 'g', '-', '2', '*', '{', '[', '#', '}', '7', '6', 'B', '|', '~', ';', '/', '\\', 'G', 's', 'N', 'X', 'k', 'j', '8', '$', 'y', 'u', 'h', 'e', 'd', 'E', 'I', 'c', '?', '^', ']', '\'', '%', '=', '0', ':', 'q', ' ', 'Z', ',', 'b', '<', '3', '!', 'a', '>', 'M', 'T', 'P', 'U', '\u00df', '\u00e1', '\u00d8', '\u00bb', '\u00a6', '\u00e5', '\u00bd', '\u00de', '\u00bc', '\u008d', '\u00f9', '\u0094', '\u00c8', '\u00b8', '\u0088', '\u00f8', '\u00be', '\u00c7', '\u00aa', '\u00b5', '\u00cc', '\u008a', '\u00e8', '\u00da', '\u00b7', '\u00ff', '\u00ea', '\u00dc', '\u00f7', '\u00d5', '\u00cb', '\u00e2', '\u00c1', '\u00ae', '\u00ac', '\u00e4', '\u00fc', '\u00d9', '\u00c9', '\u0083', '\u00e6', '\u00c5', '\u00d3', '\u0091', '\u00ee', '\u00a1', '\u00b3', '\u00a0', '\u00d4', '\u00cf', '\u00dd', '\u00fe', '\u00ad', '\u00ca', '\u0092', '\u00e0', '\u0097', '\u008c', '\u00c4', '\u00cd', '\u0082', '\u0087', '\u0085', '\u008f', '\u00f6', '\u00c0', '\u009f', '\u00f4', '\u00ef', '\u00b9', '\u00a8', '\u00d7', '\u0090', '\u008b', '\u00a5', '\u00b4', '\u009d', '\u0093', '\u00ba', '\u00d6', '\u00b0', '\u00e3', '\u00e7', '\u00db', '\u00a9', '\u00af', '\u009c', '\u00ce', '\u00c6', '\u0081', '\u00a4', '\u0096', '\u00d2', '\u009a', '\u00b1', '\u0086', '\u007f', '\u00b6', '\u0080', '\u009e', '\u00d0', '\u00a2', '\u0084', '\u00a7', '\u00d1', '\u0095', '\u00f1', '\u0099', '\u00fb', '\u00ed', '\u00ec', '\u00ab', '\u00c3', '\u00f3', '\u00e9', '\u00fd', '\u00f0', '\u00c2', '\u00fa', '\u00bf', '\u009b', '\u008e', '\u0089', '\u00f5', '\u00eb', '\u00a3', '\u00f2', '\u00b2', '\u0098'};
    private static final String BEGIN = "BEGIN AUTH REQUEST";
    private static final String END = "END AUTH REQUEST";
    private static final String LOGIN_OK = "I LOVE YOU";
    private static final String LOGIN_FAILED = "I HATE YOU";
    private String password;
    private ICVSRepositoryLocation cvsroot;
    private Socket fSocket;
    private InputStream inputStream;
    private OutputStream outputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws IOException {
        Object v1;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            Object var2_1 = null;
            this.inputStream = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var2_2 = null;
            this.inputStream = null;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                v0 = null;
            }
            Object var4_6 = v0;
            this.outputStream = null;
            try {
                if (this.fSocket == null) throw throwable;
                this.fSocket.close();
                throw throwable;
            }
            finally {
                this.fSocket = null;
            }
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var4_5 = v1;
        this.outputStream = null;
        try {
            if (this.fSocket == null) return;
            this.fSocket.close();
            return;
        }
        finally {
            this.fSocket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(IProgressMonitor monitor) throws IOException, CVSAuthenticationException {
        monitor.subTask(Policy.bind("PServerConnection.authenticating"));
        monitor.worked(1);
        this.fSocket = this.createSocket(monitor);
        boolean connected = false;
        try {
            this.inputStream = new BufferedInputStream((InputStream)new PollingInputStream(this.fSocket.getInputStream(), this.cvsroot.getTimeout(), monitor));
            this.outputStream = new PollingOutputStream((OutputStream)new TimeoutOutputStream(this.fSocket.getOutputStream(), 8192, 1000L, 1000L), this.cvsroot.getTimeout(), monitor);
            this.authenticate();
            connected = true;
        }
        finally {
            if (!connected) {
                this.cleanUpAfterFailedConnection();
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    PServerConnection(ICVSRepositoryLocation cvsroot, String password) {
        this.cvsroot = cvsroot;
        this.password = password;
    }

    private void authenticate() throws IOException, CVSAuthenticationException {
        String scrambledPassword = this.scramblePassword(this.password);
        String user = this.cvsroot.getUsername();
        OutputStream out = this.getOutputStream();
        StringBuffer request = new StringBuffer();
        request.append(BEGIN);
        request.append('\n');
        request.append(this.cvsroot.getRootDirectory());
        request.append('\n');
        request.append(user);
        request.append('\n');
        request.append(scrambledPassword);
        request.append('\n');
        request.append(END);
        request.append('\n');
        out.write(request.toString().getBytes());
        out.flush();
        String line = Connection.readLine(this.cvsroot, this.getInputStream()).trim();
        if (LOGIN_OK.equals(line)) {
            return;
        }
        if (line.length() == 0) {
            throw new IOException(Policy.bind("PServerConnection.noResponse"));
        }
        if (LOGIN_FAILED.equals(line)) {
            throw new CVSAuthenticationException(Policy.bind("PServerConnection.loginRefused"), 1);
        }
        String message = "";
        while (line.charAt(0) == 'E') {
            line = Connection.readLine(this.cvsroot, this.getInputStream());
        }
        message = line.startsWith(ERROR_MESSAGE) ? message + line.substring(ERROR_MESSAGE.length() + 1) : message + line;
        if (message.indexOf(NO_SUCH_USER) != -1) {
            throw new CVSAuthenticationException(Policy.bind("PServerConnection.invalidUser", new Object[]{message}), 1);
        }
        throw new IOException(Policy.bind("PServerConnection.connectionRefused", new Object[]{message}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanUpAfterFailedConnection() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable2) {
                Object var4_6 = null;
                try {
                    if (this.fSocket == null) throw throwable2;
                    this.fSocket.close();
                    throw throwable2;
                }
                finally {
                    this.fSocket = null;
                }
            }
            try {
                if (this.fSocket == null) throw throwable;
                this.fSocket.close();
                throw throwable;
            }
            finally {
                this.fSocket = null;
            }
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (this.fSocket == null) throw throwable;
                this.fSocket.close();
                throw throwable;
            }
            finally {
                this.fSocket = null;
            }
        }
        try {
            if (this.fSocket == null) return;
            this.fSocket.close();
            return;
        }
        finally {
            this.fSocket = null;
        }
    }

    protected Socket createSocket(IProgressMonitor monitor) throws IOException {
        Socket result;
        int port = this.cvsroot.getPort();
        if (port == 0) {
            port = 2401;
        }
        try {
            result = Util.createSocket(this.cvsroot.getHost(), port, monitor);
            result.setTcpNoDelay(true);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedIOException(Policy.bind("PServerConnection.socket", new Object[]{this.cvsroot.getHost()}));
        }
        result.setSoTimeout(1000);
        return result;
    }

    private String scramblePassword(String password) throws CVSAuthenticationException {
        int length = password.length();
        char[] out = new char[length];
        for (int i = 0; i < length; ++i) {
            char value = password.charAt(i);
            if (value < '\u0000' || value > '\u00ff') {
                this.throwInValidCharacter();
            }
            out[i] = SCRAMBLING_TABLE[value];
        }
        return "A" + new String(out);
    }

    private void throwInValidCharacter() throws CVSAuthenticationException {
        throw new CVSAuthenticationException(Policy.bind("PServerConnection.invalidChars"), 1);
    }
}

