/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.core.model.NonPluginEntryModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.InstallHandlerProxy;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class Feature
extends FeatureModel
implements IFeature {
    public static final String FEATURE_FILE = "feature";
    public static final String FEATURE_XML = "feature.xml";
    private ISite site;
    private IFeatureContentProvider featureContentProvider;
    private List includedFeatureReferences;
    private VersionedIdentifier versionId;
    private InstallAbortedException abortedException = null;

    public boolean equals(Object object) {
        if (!(object instanceof IFeature)) {
            return false;
        }
        IFeature f = (IFeature)object;
        return this.getVersionedIdentifier().equals(f.getVersionedIdentifier());
    }

    public VersionedIdentifier getVersionedIdentifier() {
        if (this.versionId != null) {
            return this.versionId;
        }
        String id = this.getFeatureIdentifier();
        String ver = this.getFeatureVersion();
        if (id != null && ver != null) {
            try {
                this.versionId = new VersionedIdentifier(id, ver);
                return this.versionId;
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to create versioned identifier:" + id + ":" + ver);
            }
        }
        this.versionId = new VersionedIdentifier(this.getURL().toExternalForm(), null);
        return this.versionId;
    }

    public ISite getSite() {
        return this.site;
    }

    public URL getURL() {
        IFeatureContentProvider contentProvider = null;
        try {
            contentProvider = this.getFeatureContentProvider();
        }
        catch (CoreException e) {
            UpdateCore.warn("No content Provider", e);
        }
        return contentProvider != null ? contentProvider.getURL() : null;
    }

    public IURLEntry getUpdateSiteEntry() {
        return (IURLEntry)((Object)this.getUpdateSiteEntryModel());
    }

    public IURLEntry[] getDiscoverySiteEntries() {
        URLEntryModel[] result = this.getDiscoverySiteEntryModels();
        if (result.length == 0) {
            return new IURLEntry[0];
        }
        return (IURLEntry[])result;
    }

    public IInstallHandlerEntry getInstallHandlerEntry() {
        return (IInstallHandlerEntry)((Object)this.getInstallHandlerModel());
    }

    public IURLEntry getDescription() {
        return (IURLEntry)((Object)this.getDescriptionModel());
    }

    public IURLEntry getCopyright() {
        return (IURLEntry)((Object)this.getCopyrightModel());
    }

    public IURLEntry getLicense() {
        return (IURLEntry)((Object)this.getLicenseModel());
    }

    public URL getImage() {
        return this.getImageURL();
    }

    public IImport[] getRawImports() {
        ImportModel[] result = this.getImportModels();
        if (result.length == 0) {
            return new IImport[0];
        }
        return (IImport[])result;
    }

    public IFeatureReference install(IFeature targetFeature, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        return this.install(targetFeature, null, verificationListener, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IFeatureReference install(IFeature targetFeature, IFeatureReference[] optionalfeatures, IVerificationListener verificationListener, IProgressMonitor progress) throws InstallAbortedException, CoreException {
        IFeatureReference result;
        block55: {
            int i;
            this.debug("Installing...:" + this.getURL().toExternalForm());
            ErrorRecoveryLog recoveryLog = ErrorRecoveryLog.getLog();
            InstallMonitor monitor = progress == null ? new InstallMonitor((IProgressMonitor)new NullProgressMonitor()) : (progress instanceof InstallMonitor ? (InstallMonitor)progress : new InstallMonitor(progress));
            InstallHandlerProxy handler = new InstallHandlerProxy(1, this, this.getInstallHandlerEntry(), monitor);
            boolean success = false;
            CoreException originalException = null;
            this.abortedException = null;
            IFeatureContentProvider provider = this.getFeatureContentProvider();
            IVerifier verifier = provider.getVerifier();
            result = null;
            IFeatureReference alreadyInstalledFeature = null;
            IFeatureContentConsumer consumer = null;
            IPluginEntry[] targetSitePluginEntries = null;
            IPluginEntry[] sourceFeaturePluginEntries = this.getPluginEntries();
            ISite targetSite = targetFeature.getSite();
            if (targetSite == null) {
                this.debug("The site to install in is null");
                targetSitePluginEntries = new IPluginEntry[]{};
            } else {
                targetSitePluginEntries = targetSite.getPluginEntries();
            }
            IPluginEntry[] pluginsToInstall = UpdateManagerUtils.diff(sourceFeaturePluginEntries, targetSitePluginEntries);
            INonPluginEntry[] nonPluginsToInstall = this.getNonPluginEntries();
            IFeatureReference[] children = this.getIncludedFeatureReferences();
            if (optionalfeatures != null) {
                children = UpdateManagerUtils.optionalChildrenToInstall(children, optionalfeatures);
            }
            int taskCount = 2 + 2 * pluginsToInstall.length + nonPluginsToInstall.length + 1 + 5 * children.length;
            monitor.beginTask("", taskCount);
            SubProgressMonitor subMonitor = null;
            recoveryLog.open("START_INSTALL_LOG");
            handler.installInitiated();
            ContentReference[] references = provider.getFeatureEntryArchiveReferences(monitor);
            this.verifyReferences(verifier, references, monitor, verificationListener, true);
            this.monitorWork(monitor, 1);
            for (i = 0; i < pluginsToInstall.length; ++i) {
                references = provider.getPluginEntryArchiveReferences(pluginsToInstall[i], monitor);
                this.verifyReferences(verifier, references, monitor, verificationListener, false);
                this.monitorWork(monitor, 1);
            }
            handler.pluginsDownloaded(pluginsToInstall);
            for (i = 0; i < nonPluginsToInstall.length; ++i) {
                references = provider.getNonPluginEntryArchiveReferences(nonPluginsToInstall[i], monitor);
                this.monitorWork(monitor, 1);
            }
            handler.nonPluginDataDownloaded(nonPluginsToInstall, verificationListener);
            consumer = targetFeature.getFeatureContentConsumer();
            for (i = 0; i < children.length; ++i) {
                IFeature childFeature = null;
                try {
                    childFeature = children[i].getFeature(null);
                }
                catch (CoreException e) {
                    UpdateCore.warn(null, e);
                }
                if (childFeature == null) continue;
                subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 5);
                ((Site)targetSite).install(childFeature, optionalfeatures, consumer, verifier, verificationListener, (IProgressMonitor)subMonitor);
            }
            for (i = 0; i < pluginsToInstall.length; ++i) {
                if (InstallRegistry.getInstance().isPluginJustInstalled(pluginsToInstall[i])) {
                    monitor.worked(1);
                    continue;
                }
                IContentConsumer pluginConsumer = consumer.open(pluginsToInstall[i]);
                references = pluginsToInstall[i] instanceof PluginEntryModel && !((PluginEntryModel)((Object)pluginsToInstall[i])).isUnpack() ? provider.getPluginEntryArchiveReferences(pluginsToInstall[i], monitor) : provider.getPluginEntryContentReferences(pluginsToInstall[i], monitor);
                String msg = "";
                subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                VersionedIdentifier pluginVerId = pluginsToInstall[i].getVersionedIdentifier();
                String pluginID = pluginVerId == null ? "" : pluginVerId.getIdentifier();
                msg = Policy.bind("Feature.TaskInstallPluginFiles", pluginID);
                for (int j = 0; j < references.length; ++j) {
                    this.setMonitorTaskName((IProgressMonitor)subMonitor, msg + references[j].getIdentifier());
                    pluginConsumer.store(references[j], (IProgressMonitor)subMonitor);
                }
                InstallRegistry.registerPlugin(pluginsToInstall[i]);
                if (!monitor.isCanceled()) continue;
                this.abort();
            }
            alreadyInstalledFeature = this.featureAlreadyInstalled(targetSite);
            if (alreadyInstalledFeature == null) {
                references = provider.getFeatureEntryContentReferences(monitor);
                String msg = "";
                subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 1);
                msg = Policy.bind("Feature.TaskInstallFeatureFiles");
                for (int i2 = 0; i2 < references.length; ++i2) {
                    this.setMonitorTaskName((IProgressMonitor)subMonitor, msg + " " + references[i2].getIdentifier());
                    consumer.store(references[i2], (IProgressMonitor)subMonitor);
                }
                InstallRegistry.registerFeature(this);
            } else {
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                this.abort();
            }
            handler.completeInstall(consumer);
            this.monitorWork(monitor, 1);
            success = true;
            Object var31_35 = null;
            CoreException newException = null;
            try {
                if (consumer != null) {
                    if (success) {
                        result = consumer.close();
                        if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                            this.reinitializeFeature(result);
                        }
                        recoveryLog.close("END_INSTALL_LOG");
                    } else {
                        consumer.abort();
                    }
                }
                handler.installCompleted(success);
                recoveryLog.delete();
            }
            catch (CoreException e2) {
                newException = e2;
            }
            if (originalException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
            }
            if (newException != null) {
                throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
            }
            if (this.abortedException != null) {
                throw this.abortedException;
            }
            break block55;
            {
                catch (InstallAbortedException e) {
                    this.abortedException = e;
                    Object var31_36 = null;
                    newException = null;
                    try {
                        if (consumer != null) {
                            if (success) {
                                result = consumer.close();
                                if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                                    this.reinitializeFeature(result);
                                }
                                recoveryLog.close("END_INSTALL_LOG");
                            } else {
                                consumer.abort();
                            }
                        }
                        handler.installCompleted(success);
                        recoveryLog.delete();
                    }
                    catch (CoreException e2) {
                        newException = e2;
                    }
                    if (originalException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
                    }
                    if (newException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
                    }
                    if (this.abortedException != null) {
                        throw this.abortedException;
                    }
                    break block55;
                }
                catch (CoreException e) {
                    originalException = e;
                    Object var31_37 = null;
                    newException = null;
                    try {
                        if (consumer != null) {
                            if (success) {
                                result = consumer.close();
                                if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                                    this.reinitializeFeature(result);
                                }
                                recoveryLog.close("END_INSTALL_LOG");
                            } else {
                                consumer.abort();
                            }
                        }
                        handler.installCompleted(success);
                        recoveryLog.delete();
                    }
                    catch (CoreException e2) {
                        newException = e2;
                    }
                    if (originalException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
                    }
                    if (newException != null) {
                        throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
                    }
                    if (this.abortedException != null) {
                        throw this.abortedException;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var31_38 = null;
                newException = null;
                try {
                    if (consumer != null) {
                        if (success) {
                            result = consumer.close();
                            if (result == null && (result = alreadyInstalledFeature) != null && optionalfeatures != null && optionalfeatures.length > 0) {
                                this.reinitializeFeature(result);
                            }
                            recoveryLog.close("END_INSTALL_LOG");
                        } else {
                            consumer.abort();
                        }
                    }
                    handler.installCompleted(success);
                    recoveryLog.delete();
                }
                catch (CoreException e2) {
                    newException = e2;
                }
                if (originalException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), originalException);
                }
                if (newException != null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.error", this.getLabel()), newException);
                }
                if (this.abortedException != null) {
                    throw this.abortedException;
                }
                throw throwable;
            }
        }
        return result;
    }

    public IPluginEntry[] getRawPluginEntries() {
        PluginEntryModel[] result = this.getPluginEntryModels();
        if (result.length == 0) {
            return new IPluginEntry[0];
        }
        return (IPluginEntry[])result;
    }

    private IPluginEntry[] filterPluginEntry(IPluginEntry[] all) {
        ArrayList<IPluginEntry> list = new ArrayList<IPluginEntry>();
        if (all != null) {
            for (int i = 0; i < all.length; ++i) {
                if (!UpdateManagerUtils.isValidEnvironment(all[i])) continue;
                list.add(all[i]);
            }
        }
        IPluginEntry[] result = new IPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public int getPluginEntryCount() {
        return this.getPluginEntries().length;
    }

    public INonPluginEntry[] getRawNonPluginEntries() {
        NonPluginEntryModel[] result = this.getNonPluginEntryModels();
        if (result.length == 0) {
            return new INonPluginEntry[0];
        }
        return (INonPluginEntry[])result;
    }

    public int getNonPluginEntryCount() {
        return this.getNonPluginEntryModels().length;
    }

    public IIncludedFeatureReference[] getRawIncludedFeatureReferences() throws CoreException {
        if (this.includedFeatureReferences == null) {
            this.initializeIncludedReferences();
        }
        if (this.includedFeatureReferences.size() == 0) {
            return new IncludedFeatureReference[0];
        }
        return (IIncludedFeatureReference[])this.includedFeatureReferences.toArray(this.arrayTypeFor(this.includedFeatureReferences));
    }

    public long getDownloadSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            for (int i = 0; i < children.length; ++i) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getDownloadSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public long getInstallSize() {
        try {
            HashSet<IPluginEntry> allPluginEntries = new HashSet<IPluginEntry>();
            HashSet<INonPluginEntry> allNonPluginEntries = new HashSet<INonPluginEntry>();
            IPluginEntry[] plugins = this.getPluginEntries();
            allPluginEntries.addAll(Arrays.asList(plugins));
            INonPluginEntry[] nonPlugins = this.getNonPluginEntries();
            allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            IIncludedFeatureReference[] children = this.getIncludedFeatureReferences();
            for (int i = 0; i < children.length; ++i) {
                plugins = children[i].getFeature(null).getPluginEntries();
                allPluginEntries.addAll(Arrays.asList(plugins));
                nonPlugins = children[i].getFeature(null).getNonPluginEntries();
                allNonPluginEntries.addAll(Arrays.asList(nonPlugins));
            }
            IPluginEntry[] totalPlugins = new IPluginEntry[allPluginEntries.size()];
            INonPluginEntry[] totalNonPlugins = new INonPluginEntry[allNonPluginEntries.size()];
            if (allPluginEntries.size() != 0) {
                allPluginEntries.toArray(totalPlugins);
            }
            if (allNonPluginEntries.size() != 0) {
                allNonPluginEntries.toArray(totalNonPlugins);
            }
            return this.getFeatureContentProvider().getInstallSizeFor(totalPlugins, totalNonPlugins);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return -1L;
        }
    }

    public IFeatureContentProvider getFeatureContentProvider() throws CoreException {
        if (this.featureContentProvider == null) {
            throw Utilities.newCoreException(Policy.bind("Feature.NoContentProvider", this.getVersionedIdentifier().toString()), null);
        }
        return this.featureContentProvider;
    }

    public IFeatureContentConsumer getFeatureContentConsumer() throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSite(ISite site) throws CoreException {
        if (this.site != null) {
            String featureURLString = this.getURL() != null ? this.getURL().toExternalForm() : "";
            throw Utilities.newCoreException(Policy.bind("Feature.SiteAlreadySet", featureURLString), null);
        }
        this.site = site;
    }

    public void setFeatureContentProvider(IFeatureContentProvider featureContentProvider) {
        this.featureContentProvider = featureContentProvider;
        featureContentProvider.setFeature(this);
    }

    public String toString() {
        String URLString = this.getURL() == null ? Policy.bind("Feature.NoURL") : this.getURL().toExternalForm();
        String verString = Policy.bind("Feature.FeatureVersionToString", URLString, this.getVersionedIdentifier().toString());
        String label = this.getLabel() == null ? "" : this.getLabel();
        return verString + " [" + label + "]";
    }

    private void abort() throws CoreException {
        String msg = Policy.bind("Feature.InstallationCancelled");
        throw new InstallAbortedException(msg, null);
    }

    private void initializeIncludedReferences() throws CoreException {
        this.includedFeatureReferences = new ArrayList();
        IIncludedFeatureReference[] nestedFeatures = this.getFeatureIncluded();
        if (nestedFeatures.length == 0) {
            return;
        }
        ISite site = this.getSite();
        if (site == null) {
            return;
        }
        for (int i = 0; i < nestedFeatures.length; ++i) {
            IIncludedFeatureReference include = nestedFeatures[i];
            IIncludedFeatureReference newRef = this.getPerfectIncludeFeature(site, include);
            this.includedFeatureReferences.add(newRef);
        }
    }

    private IIncludedFeatureReference getPerfectIncludeFeature(ISite site, IIncludedFeatureReference include) throws CoreException {
        ISiteFeatureReference[] refs = site.getFeatureReferences();
        VersionedIdentifier identifier = include.getVersionedIdentifier();
        if ("file".equals(site.getURL().getProtocol()) && refs != null) {
            for (int ref = 0; ref < refs.length; ++ref) {
                VersionedIdentifier id;
                if (refs[ref] == null || !identifier.equals(id = refs[ref].getVersionedIdentifier())) continue;
                IncludedFeatureReference newRef = new IncludedFeatureReference(refs[ref]);
                newRef.isOptional(include.isOptional());
                if (include instanceof FeatureReferenceModel) {
                    newRef.setLabel(((FeatureReferenceModel)((Object)include)).getLabel());
                }
                newRef.setSearchLocation(include.getSearchLocation());
                return newRef;
            }
        }
        IncludedFeatureReference newRef = new IncludedFeatureReference(include);
        newRef.setSite(this.getSite());
        ISiteFeatureReference parentRef = this.getSite().getFeatureReference(this);
        if (parentRef instanceof FeatureReference) {
            newRef.setType(((FeatureReference)((Object)parentRef)).getType());
        }
        String featureID = "features/" + identifier.toString() + ".jar";
        URL featureURL = this.getSite().getSiteContentProvider().getArchiveReference(featureID);
        newRef.setURL(featureURL);
        newRef.setFeatureIdentifier(identifier.getIdentifier());
        newRef.setFeatureVersion(identifier.getVersion().toString());
        try {
            newRef.resolve(this.getSite().getURL(), null);
            return newRef;
        }
        catch (Exception e) {
            throw Utilities.newCoreException(Policy.bind("Feature.UnableToInitializeFeatureReference", identifier.toString()), e);
        }
    }

    private void debug(String trace) {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
            UpdateCore.debug(trace);
        }
    }

    private void setMonitorTaskName(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.setTaskName(taskName);
        }
    }

    private void monitorWork(IProgressMonitor monitor, int tick) throws CoreException {
        if (monitor != null) {
            monitor.worked(tick);
            if (monitor.isCanceled()) {
                this.abort();
            }
        }
    }

    private void verifyReferences(IVerifier verifier, ContentReference[] references, InstallMonitor monitor, IVerificationListener verificationListener, boolean isFeature) throws CoreException {
        IVerificationResult vr = null;
        if (verifier != null) {
            for (int j = 0; j < references.length; ++j) {
                vr = verifier.verify(this, references[j], isFeature, monitor);
                if (vr == null) continue;
                if (verificationListener == null) {
                    return;
                }
                int result = verificationListener.prompt(vr);
                if (result == 0) {
                    String msg = Policy.bind("JarVerificationService.CancelInstall");
                    Exception e = vr.getVerificationException();
                    throw new InstallAbortedException(msg, e);
                }
                if (result != 1) continue;
                throw Utilities.newCoreException(Policy.bind("JarVerificationService.UnsucessfulVerification"), vr.getVerificationException());
            }
        }
    }

    private IFeatureReference featureAlreadyInstalled(ISite targetSite) {
        ISiteFeatureReference[] references = targetSite.getFeatureReferences();
        ISiteFeatureReference currentReference = null;
        for (int i = 0; i < references.length; ++i) {
            currentReference = references[i];
            try {
                if (!this.equals(currentReference.getFeature(null))) continue;
                return currentReference;
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
        }
        UpdateCore.warn("ValidateAlreadyInstalled:Feature " + this + " not found on site:" + this.getURL());
        return null;
    }

    private void reinitializeFeature(IFeatureReference referenceToReinitialize) {
        if (referenceToReinitialize == null) {
            return;
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.debug("Re initialize feature reference:" + referenceToReinitialize);
        }
        IFeature feature = null;
        try {
            ISite site;
            feature = referenceToReinitialize.getFeature(null);
            if (feature != null && feature instanceof Feature) {
                ((Feature)feature).initializeIncludedReferences();
            }
            if ((site = referenceToReinitialize.getSite()) == null) {
                return;
            }
            URL url = site.getURL();
            if (url == null) {
                return;
            }
            if ("file".equals(url.getProtocol())) {
                IIncludedFeatureReference[] included = feature.getIncludedFeatureReferences();
                for (int i = 0; i < included.length; ++i) {
                    this.reinitializeFeature(included[i]);
                }
            }
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
        }
    }

    public IIncludedFeatureReference[] getIncludedFeatureReferences() throws CoreException {
        return this.filterFeatures(this.getRawIncludedFeatureReferences());
    }

    private IIncludedFeatureReference[] filterFeatures(IIncludedFeatureReference[] allIncluded) {
        ArrayList<IIncludedFeatureReference> list = new ArrayList<IIncludedFeatureReference>();
        if (allIncluded != null) {
            for (int i = 0; i < allIncluded.length; ++i) {
                IIncludedFeatureReference included = allIncluded[i];
                if (UpdateManagerUtils.isValidEnvironment(included)) {
                    list.add(included);
                    continue;
                }
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) continue;
                UpdateCore.warn("Filtered out feature reference:" + included);
            }
        }
        IIncludedFeatureReference[] result = new IIncludedFeatureReference[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public INonPluginEntry[] getNonPluginEntries() {
        return this.filterNonPluginEntry(this.getRawNonPluginEntries());
    }

    private INonPluginEntry[] filterNonPluginEntry(INonPluginEntry[] all) {
        ArrayList<INonPluginEntry> list = new ArrayList<INonPluginEntry>();
        if (all != null) {
            for (int i = 0; i < all.length; ++i) {
                if (!UpdateManagerUtils.isValidEnvironment(all[i])) continue;
                list.add(all[i]);
            }
        }
        INonPluginEntry[] result = new INonPluginEntry[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }

    public IPluginEntry[] getPluginEntries() {
        return this.filterPluginEntry(this.getRawPluginEntries());
    }

    public IImport[] getImports() {
        return this.filterImports(this.getRawImports());
    }

    private IImport[] filterImports(IImport[] all) {
        ArrayList<IImport> list = new ArrayList<IImport>();
        if (all != null) {
            for (int i = 0; i < all.length; ++i) {
                if (!UpdateManagerUtils.isValidEnvironment(all[i])) continue;
                list.add(all[i]);
            }
        }
        IImport[] result = new IImport[list.size()];
        if (!list.isEmpty()) {
            list.toArray(result);
        }
        return result;
    }
}

