/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.core.BaseSiteFactory;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.Response;
import org.eclipse.update.internal.core.SiteURLContentProvider;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteURLFactory
extends BaseSiteFactory
implements ISiteFactoryExtension {
    public ISite createSite(URL url) throws CoreException, InvalidSiteTypeException {
        return this.createSite(url, null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISite createSite(URL url, IProgressMonitor monitor) throws CoreException, InvalidSiteTypeException {
        SiteURLContentProvider contentProvider;
        InputStream siteStream;
        Site site;
        block10: {
            site = null;
            siteStream = null;
            contentProvider = new SiteURLContentProvider(url);
            URL resolvedURL = URLEncoder.encode(url);
            Response response = UpdateCore.getPlugin().get(resolvedURL);
            UpdateManagerUtils.checkConnectionResult(response, resolvedURL);
            siteStream = response.getInputStream(monitor);
            if (siteStream != null) break block10;
            ISite iSite = null;
            Object var10_12 = null;
            if (siteStream == null) return iSite;
            try {
                siteStream.close();
                return iSite;
            }
            catch (IOException e) {
                // empty catch block
            }
            return iSite;
        }
        SiteURLFactory factory = this;
        site = (Site)factory.parseSite(siteStream);
        site.setSiteContentProvider(contentProvider);
        contentProvider.setSite(site);
        site.resolve(url, url);
        site.markReadOnly();
        Object var10_13 = null;
        if (siteStream == null) return site;
        try {
            siteStream.close();
            return site;
        }
        catch (IOException e) {}
        return site;
        {
            catch (MalformedURLException e) {
                throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToCreateURL", url == null ? "" : url.toExternalForm()), e);
            }
            catch (IOException e) {
                throw Utilities.newCoreException(Policy.bind("SiteURLFactory.UnableToAccessSiteStream", url == null ? "" : url.toExternalForm()), 42, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (siteStream == null) throw throwable;
            try {
                siteStream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public boolean canParseSiteType(String type) {
        return super.canParseSiteType(type) || "org.eclipse.update.core.http".equalsIgnoreCase(type);
    }
}

