/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionStatus;
import org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import org.eclipse.core.internal.expressions.TypeExtensionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class TypeExtension {
    private static final TypeExtension[] EMPTY_TYPE_EXTENSION_ARRAY = new TypeExtension[0];
    static final IPropertyTester CONTINUE = new IPropertyTester(){

        public boolean handles(String namespace, String method) {
            return false;
        }

        public boolean isInstantiated() {
            return true;
        }

        public boolean isDeclaringPluginActive() {
            return true;
        }

        public IPropertyTester instantiate() {
            return this;
        }

        public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
            return false;
        }
    };
    private static final TypeExtension END_POINT = new TypeExtension(){

        IPropertyTester findTypeExtender(TypeExtensionManager manager, String namespace, String name, boolean staticMethod) throws CoreException {
            return CONTINUE;
        }
    };
    private Class fType;
    private IPropertyTester[] fExtenders;
    private TypeExtension fExtends;
    private TypeExtension[] fImplements;

    private TypeExtension() {
    }

    TypeExtension(Class type) {
        Assert.isNotNull(type);
        this.fType = type;
    }

    IPropertyTester findTypeExtender(TypeExtensionManager manager, String namespace, String method, boolean staticMethod) throws CoreException {
        IPropertyTester result;
        int i;
        if (this.fExtenders == null) {
            this.fExtenders = manager.loadTesters(this.fType);
        }
        for (i = 0; i < this.fExtenders.length; ++i) {
            IPropertyTester extender = this.fExtenders[i];
            if (extender == null || !extender.handles(namespace, method)) continue;
            if (extender.isInstantiated()) {
                if (extender.isDeclaringPluginActive()) {
                    return extender;
                }
                PropertyTester tester = (PropertyTester)extender;
                this.fExtenders[i] = extender = tester.internalCreateDescriptor();
                return extender;
            }
            if (extender.isDeclaringPluginActive()) {
                try {
                    PropertyTesterDescriptor descriptor = (PropertyTesterDescriptor)extender;
                    IPropertyTester inst = descriptor.instantiate();
                    ((PropertyTester)inst).internalInitialize(descriptor);
                    this.fExtenders[i] = extender = inst;
                    return extender;
                }
                catch (CoreException e) {
                    this.fExtenders[i] = null;
                    throw e;
                }
                catch (ClassCastException e) {
                    this.fExtenders[i] = null;
                    throw new CoreException((IStatus)new ExpressionStatus(202, ExpressionMessages.getString("TypeExtender.incorrectType"), e));
                }
            }
            return extender;
        }
        if (staticMethod) {
            return CONTINUE;
        }
        if (this.fExtends == null) {
            Class superClass = this.fType.getSuperclass();
            this.fExtends = superClass != null ? manager.get(superClass) : END_POINT;
        }
        if ((result = this.fExtends.findTypeExtender(manager, namespace, method, staticMethod)) != CONTINUE) {
            return result;
        }
        if (this.fImplements == null) {
            Class<?>[] interfaces = this.fType.getInterfaces();
            if (interfaces.length == 0) {
                this.fImplements = EMPTY_TYPE_EXTENSION_ARRAY;
            } else {
                this.fImplements = new TypeExtension[interfaces.length];
                for (int i2 = 0; i2 < interfaces.length; ++i2) {
                    this.fImplements[i2] = manager.get(interfaces[i2]);
                }
            }
        }
        for (i = 0; i < this.fImplements.length; ++i) {
            result = this.fImplements[i].findTypeExtender(manager, namespace, method, staticMethod);
            if (result == CONTINUE) continue;
            return result;
        }
        return CONTINUE;
    }
}

