/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.osgi.framework.Bundle;

public class ContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TEMPLATE = "template";
    private static final String PATTERN = "pattern";
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";

    public ContributionTemplateStore(IPreferenceStore store, String key) {
        super(store, key);
    }

    public ContributionTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    protected void loadContributedTemplates() throws IOException {
        IConfigurationElement[] extensions = ContributionTemplateStore.getTemplateExtensions();
        Collection contributed = this.readContributedTemplates(extensions);
        Iterator it = contributed.iterator();
        while (it.hasNext()) {
            TemplatePersistenceData data = (TemplatePersistenceData)it.next();
            this.internalAdd(data);
        }
    }

    private Collection readContributedTemplates(IConfigurationElement[] extensions) throws IOException {
        ArrayList templates = new ArrayList();
        for (int i = 0; i < extensions.length; ++i) {
            if (extensions[i].getName().equals(TEMPLATE)) {
                this.createTemplate(templates, extensions[i]);
                continue;
            }
            if (!extensions[i].getName().equals(INCLUDE)) continue;
            this.readIncludedTemplates(templates, extensions[i]);
        }
        return templates;
    }

    private void readIncludedTemplates(Collection templates, IConfigurationElement element) throws IOException {
        Bundle plugin;
        URL url;
        String file = element.getAttributeAsIs(FILE);
        if (file != null && (url = Platform.find((Bundle)(plugin = Platform.getBundle((String)element.getDeclaringExtension().getNamespace())), (IPath)new Path(file))) != null) {
            PropertyResourceBundle bundle = null;
            String translations = element.getAttributeAsIs(TRANSLATIONS);
            if (translations != null) {
                URL bundleURL = Platform.find((Bundle)plugin, (IPath)new Path(translations));
                if (url != null) {
                    bundle = new PropertyResourceBundle(bundleURL.openStream());
                }
            }
            BufferedInputStream stream = new BufferedInputStream(url.openStream());
            TemplateReaderWriter reader = new TemplateReaderWriter();
            TemplatePersistenceData[] datas = reader.read((InputStream)stream, bundle);
            for (int i = 0; i < datas.length; ++i) {
                TemplatePersistenceData data = datas[i];
                if (data.isCustom()) {
                    if (data.getId() == null) {
                        EditorsPlugin.logErrorMessage(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix") + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_no_id"));
                        continue;
                    }
                    EditorsPlugin.logErrorMessage(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix") + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_deleted"));
                    continue;
                }
                if (!this.validateTemplate(data.getTemplate())) {
                    if (!this.contextExists(data.getTemplate().getContextTypeId())) continue;
                    EditorsPlugin.logErrorMessage(ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_prefix") + data.getTemplate().getName() + " " + ContributionTemplateMessages.getString("ContributionTemplateStore.ignore_postfix_validation_failed"));
                    continue;
                }
                templates.add(data);
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String contextTypeId = template.getContextTypeId();
        if (this.contextExists(contextTypeId)) {
            if (this.getRegistry() != null) {
                try {
                    this.getRegistry().getContextType(contextTypeId).validate(template.getPattern());
                }
                catch (TemplateException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean contextExists(String contextTypeId) {
        return contextTypeId != null && (this.getRegistry() == null || this.getRegistry().getContextType(contextTypeId) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private void createTemplate(Collection map, IConfigurationElement element) {
        String name;
        String id;
        String contextTypeId = element.getAttributeAsIs(CONTEXT_TYPE_ID);
        if (this.contextExists(contextTypeId) && ContributionTemplateStore.isValidTemplateId(id = element.getAttributeAsIs(ID)) && (name = element.getAttribute(NAME)) != null) {
            String pattern;
            String desc = element.getAttribute(DESCRIPTION);
            if (desc == null) {
                desc = new String();
            }
            if ((pattern = element.getChildren(PATTERN)[0].getValue()) != null) {
                Template template = new Template(name, desc, contextTypeId, pattern);
                TemplatePersistenceData data = new TemplatePersistenceData(template, true, id);
                if (this.validateTemplate(template)) {
                    map.add(data);
                }
            }
        }
    }

    private static boolean isValidTemplateId(String id) {
        return id != null && id.trim().length() != 0;
    }
}

