/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class DefaultMarkerAnnotationAccess
implements IAnnotationAccess,
IAnnotationAccessExtension {
    public static final String UNKNOWN = "org.eclipse.text.annotation.unknown";
    public static final String ERROR_SYSTEM_IMAGE = "error";
    public static final String WARNING_SYSTEM_IMAGE = "warning";
    public static final String INFO_SYSTEM_IMAGE = "info";
    public static final String TASK_SYSTEM_IMAGE = "task";
    public static final String BOOKMARK_SYSTEM_IMAGE = "bookmark";
    private static final Map MAPPING = new HashMap();
    protected MarkerAnnotationPreferences fMarkerAnnotationPreferences;
    static /* synthetic */ Class class$org$eclipse$swt$graphics$GC;
    static /* synthetic */ Class class$org$eclipse$swt$widgets$Canvas;
    static /* synthetic */ Class class$org$eclipse$swt$graphics$Rectangle;

    public DefaultMarkerAnnotationAccess(MarkerAnnotationPreferences markerAnnotationPreferences) {
        this.fMarkerAnnotationPreferences = markerAnnotationPreferences;
    }

    public DefaultMarkerAnnotationAccess() {
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        AnnotationPreferenceLookup lookup = this.getAnnotationPreferenceLookup();
        if (lookup != null) {
            return lookup.getAnnotationPreference(annotation);
        }
        return null;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    public Object getType(Annotation annotation) {
        return annotation.getType();
    }

    public boolean isMultiLine(Annotation annotation) {
        return true;
    }

    public boolean isTemporary(Annotation annotation) {
        return !annotation.isPersistent();
    }

    public String getTypeLabel(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        return preference != null ? preference.getPreferenceLabel() : null;
    }

    public int getLayer(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer();
        }
        if (annotation instanceof IAnnotationPresentation) {
            IAnnotationPresentation presentation = (IAnnotationPresentation)annotation;
            return presentation.getLayer();
        }
        try {
            Method method = annotation.getClass().getMethod("getLayer", null);
            Integer result = (Integer)method.invoke((Object)annotation, null);
            return result;
        }
        catch (SecurityException x) {
        }
        catch (IllegalArgumentException x) {
        }
        catch (NoSuchMethodException x) {
        }
        catch (IllegalAccessException x) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return 0;
    }

    public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
        Object type;
        String annotationType;
        Image image;
        if (annotation instanceof IAnnotationPresentation) {
            IAnnotationPresentation presentation = (IAnnotationPresentation)annotation;
            presentation.paint(gc, canvas, bounds);
            return;
        }
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference != null && (image = this.getImage(annotation, preference, annotationType = (type = this.getType(annotation)) == null ? null : type.toString())) != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
            return;
        }
        try {
            Method method = annotation.getClass().getMethod("paint", class$org$eclipse$swt$graphics$GC == null ? (class$org$eclipse$swt$graphics$GC = DefaultMarkerAnnotationAccess.class$("org.eclipse.swt.graphics.GC")) : class$org$eclipse$swt$graphics$GC, class$org$eclipse$swt$widgets$Canvas == null ? (class$org$eclipse$swt$widgets$Canvas = DefaultMarkerAnnotationAccess.class$("org.eclipse.swt.widgets.Canvas")) : class$org$eclipse$swt$widgets$Canvas, class$org$eclipse$swt$graphics$Rectangle == null ? (class$org$eclipse$swt$graphics$Rectangle = DefaultMarkerAnnotationAccess.class$("org.eclipse.swt.graphics.Rectangle")) : class$org$eclipse$swt$graphics$Rectangle);
            method.invoke((Object)annotation, gc, canvas, bounds);
        }
        catch (SecurityException x) {
        }
        catch (IllegalArgumentException x) {
        }
        catch (NoSuchMethodException x) {
        }
        catch (IllegalAccessException x) {
        }
        catch (InvocationTargetException x) {
            // empty catch block
        }
    }

    public boolean isPaintable(Annotation annotation) {
        if (annotation instanceof IAnnotationPresentation) {
            return true;
        }
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        Object type = this.getType(annotation);
        String annotationType = type == null ? null : type.toString();
        Image image = this.getImage(annotation, preference, annotationType);
        return image != null;
    }

    public boolean isSubtype(Object annotationType, Object potentialSupertype) {
        AnnotationTypeHierarchy hierarchy = this.getAnnotationTypeHierarchy();
        return hierarchy.isSubtype(potentialSupertype.toString(), annotationType.toString());
    }

    public Object[] getSupertypes(Object annotationType) {
        AnnotationTypeHierarchy hierarchy = this.getAnnotationTypeHierarchy();
        AnnotationType type = hierarchy.getAnnotationType(annotationType.toString());
        return type.getSuperTypes();
    }

    protected AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        return EditorsPlugin.getDefault().getAnnotationTypeHierarchy();
    }

    private String translateSymbolicImageName(String symbolicImageName) {
        return (String)MAPPING.get(symbolicImageName);
    }

    private Image getImage(Annotation annotation, AnnotationPreference preference, String annotationType) {
        Image image;
        ImageRegistry registry = EditorsPlugin.getDefault().getImageRegistry();
        IAnnotationImageProvider annotationImageProvider = preference.getAnnotationImageProvider();
        if (annotationImageProvider != null) {
            image = annotationImageProvider.getManagedImage(annotation);
            if (image != null) {
                return image;
            }
            String id = annotationImageProvider.getImageDescriptorId(annotation);
            if (id != null) {
                image = registry.get(id);
                if (image == null) {
                    ImageDescriptor descriptor = annotationImageProvider.getImageDescriptor(id);
                    registry.put(id, descriptor);
                    image = registry.get(id);
                }
                return image;
            }
        }
        if (annotationType == null) {
            return null;
        }
        image = registry.get(annotationType);
        if (image == null) {
            ImageDescriptor descriptor = preference.getImageDescriptor();
            if (descriptor != null) {
                registry.put(annotationType, descriptor);
                image = registry.get(annotationType);
            } else {
                String key = this.translateSymbolicImageName(preference.getSymbolicImageName());
                if (key != null) {
                    ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                    image = sharedImages.getImage(key);
                }
            }
        }
        return image;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAPPING.put(ERROR_SYSTEM_IMAGE, "IMG_OBJS_ERROR_TSK");
        MAPPING.put(WARNING_SYSTEM_IMAGE, "IMG_OBJS_WARN_TSK");
        MAPPING.put(INFO_SYSTEM_IMAGE, "IMG_OBJS_INFO_TSK");
        MAPPING.put(TASK_SYSTEM_IMAGE, "IMG_OBJS_TASK_TSK");
        MAPPING.put(BOOKMARK_SYSTEM_IMAGE, "IMG_OBJS_BKMRK_TSK");
    }
}

