/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

public class MethodDeclaration
extends BodyDeclaration {
    public static final ChildPropertyDescriptor JAVADOC_PROPERTY = MethodDeclaration.internalJavadocPropertyFactory(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
    public static final SimplePropertyDescriptor MODIFIERS_PROPERTY = MethodDeclaration.internalModifiersPropertyFactory(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
    public static final ChildListPropertyDescriptor MODIFIERS2_PROPERTY = MethodDeclaration.internalModifiers2PropertyFactory(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
    public static final SimplePropertyDescriptor CONSTRUCTOR_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "constructor", Boolean.TYPE, MANDATORY);
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "name", class$org$eclipse$jdt$core$dom$SimpleName == null ? (class$org$eclipse$jdt$core$dom$SimpleName = MethodDeclaration.class$("org.eclipse.jdt.core.dom.SimpleName")) : class$org$eclipse$jdt$core$dom$SimpleName, MANDATORY, NO_CYCLE_RISK);
    public static final ChildPropertyDescriptor RETURN_TYPE_PROPERTY = new ChildPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "returnType", class$org$eclipse$jdt$core$dom$Type == null ? (class$org$eclipse$jdt$core$dom$Type = MethodDeclaration.class$("org.eclipse.jdt.core.dom.Type")) : class$org$eclipse$jdt$core$dom$Type, MANDATORY, NO_CYCLE_RISK);
    public static final ChildPropertyDescriptor RETURN_TYPE2_PROPERTY = new ChildPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "returnType2", class$org$eclipse$jdt$core$dom$Type == null ? (class$org$eclipse$jdt$core$dom$Type = MethodDeclaration.class$("org.eclipse.jdt.core.dom.Type")) : class$org$eclipse$jdt$core$dom$Type, OPTIONAL, NO_CYCLE_RISK);
    public static final SimplePropertyDescriptor EXTRA_DIMENSIONS_PROPERTY = new SimplePropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "extraDimensions", Integer.TYPE, MANDATORY);
    public static final ChildListPropertyDescriptor TYPE_PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "typeParameters", class$org$eclipse$jdt$core$dom$TypeParameter == null ? (class$org$eclipse$jdt$core$dom$TypeParameter = MethodDeclaration.class$("org.eclipse.jdt.core.dom.TypeParameter")) : class$org$eclipse$jdt$core$dom$TypeParameter, NO_CYCLE_RISK);
    public static final ChildListPropertyDescriptor PARAMETERS_PROPERTY = new ChildListPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "parameters", class$org$eclipse$jdt$core$dom$SingleVariableDeclaration == null ? (class$org$eclipse$jdt$core$dom$SingleVariableDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.SingleVariableDeclaration")) : class$org$eclipse$jdt$core$dom$SingleVariableDeclaration, CYCLE_RISK);
    public static final ChildListPropertyDescriptor THROWN_EXCEPTIONS_PROPERTY = new ChildListPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "thrownExceptions", class$org$eclipse$jdt$core$dom$Name == null ? (class$org$eclipse$jdt$core$dom$Name = MethodDeclaration.class$("org.eclipse.jdt.core.dom.Name")) : class$org$eclipse$jdt$core$dom$Name, NO_CYCLE_RISK);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration, "body", class$org$eclipse$jdt$core$dom$Block == null ? (class$org$eclipse$jdt$core$dom$Block = MethodDeclaration.class$("org.eclipse.jdt.core.dom.Block")) : class$org$eclipse$jdt$core$dom$Block, OPTIONAL, CYCLE_RISK);
    private static final List PROPERTY_DESCRIPTORS_2_0;
    private static final List PROPERTY_DESCRIPTORS_3_0;
    private boolean isConstructor = false;
    private SimpleName methodName = null;
    private ASTNode.NodeList parameters = new ASTNode.NodeList(PARAMETERS_PROPERTY);
    private Type returnType = null;
    private boolean returnType2Initialized = false;
    private ASTNode.NodeList typeParameters = null;
    private int extraArrayDimensions = 0;
    private ASTNode.NodeList thrownExceptions = new ASTNode.NodeList(THROWN_EXCEPTIONS_PROPERTY);
    private Block optionalBody = null;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SimpleName;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Type;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$TypeParameter;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$SingleVariableDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Name;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$Block;

    public static List propertyDescriptors(int apiLevel) {
        if (apiLevel == 2) {
            return PROPERTY_DESCRIPTORS_2_0;
        }
        return PROPERTY_DESCRIPTORS_3_0;
    }

    MethodDeclaration(AST ast) {
        super(ast);
        if (ast.apiLevel >= 3) {
            this.typeParameters = new ASTNode.NodeList(TYPE_PARAMETERS_PROPERTY);
        }
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return MethodDeclaration.propertyDescriptors(apiLevel);
    }

    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == MODIFIERS_PROPERTY) {
            if (get) {
                return this.getModifiers();
            }
            this.setModifiers(value);
            return 0;
        }
        if (property == EXTRA_DIMENSIONS_PROPERTY) {
            if (get) {
                return this.getExtraDimensions();
            }
            this.setExtraDimensions(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == CONSTRUCTOR_PROPERTY) {
            if (get) {
                return this.isConstructor();
            }
            this.setConstructor(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }

    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == JAVADOC_PROPERTY) {
            if (get) {
                return this.getJavadoc();
            }
            this.setJavadoc((Javadoc)child);
            return null;
        }
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((SimpleName)child);
            return null;
        }
        if (property == RETURN_TYPE_PROPERTY) {
            if (get) {
                return this.getReturnType();
            }
            this.setReturnType((Type)child);
            return null;
        }
        if (property == RETURN_TYPE2_PROPERTY) {
            if (get) {
                return this.getReturnType2();
            }
            this.setReturnType2((Type)child);
            return null;
        }
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == MODIFIERS2_PROPERTY) {
            return this.modifiers();
        }
        if (property == TYPE_PARAMETERS_PROPERTY) {
            return this.typeParameters();
        }
        if (property == PARAMETERS_PROPERTY) {
            return this.parameters();
        }
        if (property == THROWN_EXCEPTIONS_PROPERTY) {
            return this.thrownExceptions();
        }
        return super.internalGetChildListProperty(property);
    }

    final ChildPropertyDescriptor internalJavadocProperty() {
        return JAVADOC_PROPERTY;
    }

    final ChildListPropertyDescriptor internalModifiers2Property() {
        return MODIFIERS2_PROPERTY;
    }

    final SimplePropertyDescriptor internalModifiersProperty() {
        return MODIFIERS_PROPERTY;
    }

    final int getNodeType0() {
        return 31;
    }

    ASTNode clone0(AST target) {
        MethodDeclaration result = new MethodDeclaration(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setJavadoc((Javadoc)ASTNode.copySubtree(target, this.getJavadoc()));
        if (this.ast.apiLevel == 2) {
            result.setModifiers(this.getModifiers());
            result.setReturnType((Type)ASTNode.copySubtree(target, this.getReturnType()));
        }
        if (this.ast.apiLevel >= 3) {
            result.modifiers().addAll(ASTNode.copySubtrees(target, this.modifiers()));
            result.typeParameters().addAll(ASTNode.copySubtrees(target, this.typeParameters()));
            result.setReturnType2((Type)ASTNode.copySubtree(target, this.getReturnType2()));
        }
        result.setConstructor(this.isConstructor());
        result.setExtraDimensions(this.getExtraDimensions());
        result.setName((SimpleName)this.getName().clone(target));
        result.parameters().addAll(ASTNode.copySubtrees(target, this.parameters()));
        result.thrownExceptions().addAll(ASTNode.copySubtrees(target, this.thrownExceptions()));
        result.setBody((Block)ASTNode.copySubtree(target, this.getBody()));
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getJavadoc());
            if (this.ast.apiLevel == 2) {
                this.acceptChild(visitor, this.getReturnType());
            } else {
                this.acceptChildren(visitor, this.modifiers);
                this.acceptChildren(visitor, this.typeParameters);
                this.acceptChild(visitor, this.getReturnType2());
            }
            this.acceptChild(visitor, this.getName());
            this.acceptChildren(visitor, this.parameters);
            this.acceptChildren(visitor, this.thrownExceptions);
            this.acceptChild(visitor, this.getBody());
        }
        visitor.endVisit(this);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean isConstructor) {
        this.preValueChange(CONSTRUCTOR_PROPERTY);
        this.isConstructor = isConstructor;
        this.postValueChange(CONSTRUCTOR_PROPERTY);
    }

    public List typeParameters() {
        if (this.typeParameters == null) {
            this.unsupportedIn2();
        }
        return this.typeParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleName getName() {
        if (this.methodName == null) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.methodName == null) {
                    this.preLazyInit();
                    this.methodName = new SimpleName(this.ast);
                    this.postLazyInit(this.methodName, NAME_PROPERTY);
                }
            }
        }
        return this.methodName;
    }

    public void setName(SimpleName methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException();
        }
        SimpleName oldChild = this.methodName;
        this.preReplaceChild(oldChild, methodName, NAME_PROPERTY);
        this.methodName = methodName;
        this.postReplaceChild(oldChild, methodName, NAME_PROPERTY);
    }

    public List parameters() {
        return this.parameters;
    }

    public boolean isVarargs() {
        if (this.modifiers == null) {
            this.unsupportedIn2();
        }
        if (this.parameters().isEmpty()) {
            return false;
        }
        SingleVariableDeclaration v = (SingleVariableDeclaration)this.parameters().get(this.parameters().size() - 1);
        return v.isVarargs();
    }

    public List thrownExceptions() {
        return this.thrownExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType() {
        this.supportedOnlyIn2();
        if (this.returnType == null) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.returnType == null) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.postLazyInit(this.returnType, RETURN_TYPE_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType(Type type) {
        this.supportedOnlyIn2();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getReturnType2() {
        this.unsupportedIn2();
        if (this.returnType == null && !this.returnType2Initialized) {
            MethodDeclaration methodDeclaration = this;
            synchronized (methodDeclaration) {
                if (this.returnType == null && !this.returnType2Initialized) {
                    this.preLazyInit();
                    this.returnType = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    this.returnType2Initialized = true;
                    this.postLazyInit(this.returnType, RETURN_TYPE2_PROPERTY);
                }
            }
        }
        return this.returnType;
    }

    public void setReturnType2(Type type) {
        this.unsupportedIn2();
        this.returnType2Initialized = true;
        Type oldChild = this.returnType;
        this.preReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
        this.returnType = type;
        this.postReplaceChild(oldChild, type, RETURN_TYPE2_PROPERTY);
    }

    public int getExtraDimensions() {
        return this.extraArrayDimensions;
    }

    public void setExtraDimensions(int dimensions) {
        if (dimensions < 0) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(EXTRA_DIMENSIONS_PROPERTY);
        this.extraArrayDimensions = dimensions;
        this.postValueChange(EXTRA_DIMENSIONS_PROPERTY);
    }

    public Block getBody() {
        return this.optionalBody;
    }

    public void setBody(Block body) {
        Block oldChild = this.optionalBody;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.optionalBody = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public IMethodBinding resolveBinding() {
        return this.ast.getBindingResolver().resolveMethod(this);
    }

    void appendDebugString(StringBuffer buffer) {
        buffer.append("MethodDeclaration[");
        buffer.append(this.isConstructor() ? "constructor " : "method ");
        buffer.append(this.getName().getIdentifier());
        buffer.append("(");
        Iterator it = this.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration d = (SingleVariableDeclaration)it.next();
            d.getType().appendPrintString(buffer);
            if (!it.hasNext()) continue;
            buffer.append(";");
        }
        buffer.append(")");
        buffer.append("]");
    }

    int memSize() {
        return super.memSize() + 36;
    }

    int treeSize() {
        return this.memSize() + (this.optionalDocComment == null ? 0 : this.getJavadoc().treeSize()) + (this.modifiers == null ? 0 : this.modifiers.listSize()) + (this.typeParameters == null ? 0 : this.typeParameters.listSize()) + (this.methodName == null ? 0 : this.getName().treeSize()) + (this.returnType == null ? 0 : this.returnType.treeSize()) + this.parameters.listSize() + this.thrownExceptions.listSize() + (this.optionalBody == null ? 0 : this.getBody().treeSize());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MethodDeclaration.createPropertyList(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY);
        MethodDeclaration.addProperty(MODIFIERS_PROPERTY);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY);
        MethodDeclaration.addProperty(RETURN_TYPE_PROPERTY);
        MethodDeclaration.addProperty(NAME_PROPERTY);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY);
        MethodDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY);
        MethodDeclaration.addProperty(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS_2_0 = MethodDeclaration.reapPropertyList();
        MethodDeclaration.createPropertyList(class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = MethodDeclaration.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration);
        MethodDeclaration.addProperty(JAVADOC_PROPERTY);
        MethodDeclaration.addProperty(MODIFIERS2_PROPERTY);
        MethodDeclaration.addProperty(CONSTRUCTOR_PROPERTY);
        MethodDeclaration.addProperty(TYPE_PARAMETERS_PROPERTY);
        MethodDeclaration.addProperty(RETURN_TYPE2_PROPERTY);
        MethodDeclaration.addProperty(NAME_PROPERTY);
        MethodDeclaration.addProperty(PARAMETERS_PROPERTY);
        MethodDeclaration.addProperty(EXTRA_DIMENSIONS_PROPERTY);
        MethodDeclaration.addProperty(THROWN_EXCEPTIONS_PROPERTY);
        MethodDeclaration.addProperty(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS_3_0 = MethodDeclaration.reapPropertyList();
    }
}

