/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class AllocationExpression
extends Expression
implements InvocationSite {
    public TypeReference type;
    public Expression[] arguments;
    public MethodBinding binding;
    MethodBinding syntheticAccessor;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.checkCapturedLocalInitializationIfNecessary(this.binding.declaringClass, currentScope, flowInfo);
        if (this.arguments != null) {
            int count = this.arguments.length;
            for (int i = 0; i < count; ++i) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo, currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public void checkCapturedLocalInitializationIfNecessary(ReferenceBinding checkedType, BlockScope currentScope, FlowInfo flowInfo) {
        NestedTypeBinding nestedType;
        SyntheticArgumentBinding[] syntheticArguments;
        if (checkedType.isLocalType() && !checkedType.isAnonymousType() && !currentScope.isDefinedInType(checkedType) && (syntheticArguments = (nestedType = (NestedTypeBinding)checkedType).syntheticOuterLocalVariables()) != null) {
            int count = syntheticArguments.length;
            for (int i = 0; i < count; ++i) {
                SyntheticArgumentBinding syntheticArgument = syntheticArguments[i];
                LocalVariableBinding targetLocal = syntheticArgument.actualOuterLocalVariable;
                if (targetLocal == null || targetLocal.declaration == null || flowInfo.isDefinitelyAssigned(targetLocal)) continue;
                currentScope.problemReporter().uninitializedLocalVariable(targetLocal, this);
            }
        }
    }

    public Expression enclosingInstance() {
        return null;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int i;
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.binding.declaringClass;
        codeStream.new_(allocatedType);
        if (valueRequired) {
            codeStream.dup();
        }
        codeStream.recordPositionsFrom(pc, this.type.sourceStart);
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
        }
        if (this.arguments != null) {
            int count = this.arguments.length;
            for (i = 0; i < count; ++i) {
                this.arguments[i].generateCode(currentScope, codeStream, true);
            }
        }
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.binding);
        } else {
            int max = this.syntheticAccessor.parameters.length - this.binding.parameters.length;
            for (i = 0; i < max; ++i) {
                codeStream.aconst_null();
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean isSuperAccess() {
        return false;
    }

    public boolean isTypeAccess() {
        return true;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (allocatedType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedType.isLocalType()) {
                ((LocalTypeBinding)allocatedType).addInnerEmulationDependent(currentScope, false);
            } else {
                currentScope.propagateInnerEmulation(allocatedType, false);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.isPrivate() && currentScope.enclosingSourceType() != this.binding.declaringClass) {
            if (currentScope.environment().options.isPrivateConstructorAccessChangingVisibility) {
                this.binding.tagForClearingPrivateModifier();
            } else {
                this.syntheticAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(this.binding, this);
            }
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.type.printExpression(0, output);
        output.append('(');
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = NotAConstant;
        this.resolvedType = this.type.resolveType(scope);
        boolean argsContainCast = false;
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            for (int i = 0; i < length; ++i) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = argument.resolveType(scope)) != null) continue;
                argHasError = true;
            }
            if (argHasError) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.canBeInstantiated()) {
            scope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding allocationType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocationType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                this.binding.declaringClass = allocationType;
            }
            scope.problemReporter().invalidConstructor(this, this.binding);
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
            }
            if (argsContainCast) {
                CastExpression.checkNeedForArgumentCasts(scope, null, allocationType, this.binding, this.arguments, argumentTypes, this);
            }
        }
        return allocationType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int i) {
    }

    public void setFieldIndex(int i) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                for (int i = 0; i < argumentsLength; ++i) {
                    this.arguments[i].traverse(visitor, scope);
                }
            }
        }
        visitor.endVisit(this, scope);
    }
}

