/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class JavadocAllocationExpression
extends AllocationExpression {
    public int tagSourceStart;
    public int tagSourceEnd;
    public boolean superAccess = false;

    public JavadocAllocationExpression(long pos) {
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)pos;
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope) {
        this.constant = NotAConstant;
        this.resolvedType = this.type == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.type.resolveType((ClassScope)scope) : this.type.resolveType((BlockScope)scope));
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            for (int i = 0; i < length; ++i) {
                Expression argument = this.arguments[i];
                argumentTypes[i] = scope.kind == 3 ? argument.resolveType((ClassScope)scope) : argument.resolveType((BlockScope)scope);
                if (argumentTypes[i] != null) continue;
                argHasError = true;
            }
            if (argHasError) {
                return null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        this.superAccess = scope.enclosingSourceType().isCompatibleWith(this.resolvedType);
        ReferenceBinding allocationType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocationType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            MethodBinding methodBinding = scope.getMethod(this.resolvedType, this.resolvedType.sourceName(), argumentTypes, this);
            if (methodBinding.isValidBinding()) {
                this.binding = methodBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().javadocInvalidConstructor(this, this.binding, scope.getDeclarationModifiers());
            }
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        return allocationType;
    }

    public boolean isSuperAccess() {
        return this.superAccess;
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }
}

