/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SynchronizedStatement
extends SubRoutineStatement {
    public Expression expression;
    public Block block;
    public BlockScope scope;
    boolean blockExit;
    public LocalVariableBinding synchroVariable;
    static final char[] SecretLocalDeclarationName = " syncValue".toCharArray();

    public SynchronizedStatement(Expression expression, Block statement, int s, int e) {
        this.expression = expression;
        this.block = statement;
        this.sourceEnd = e;
        this.sourceStart = s;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.synchroVariable.useFlag = 1;
        this.blockExit = !(flowInfo = this.block.analyseCode(this.scope, new InsideSubRoutineFlowContext(flowContext, this), this.expression.analyseCode(this.scope, flowContext, flowInfo))).isReachable();
        return flowInfo;
    }

    public boolean isSubRoutineEscaping() {
        return false;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.anyExceptionLabelsCount > 0) {
            this.anyExceptionLabels = NO_EXCEPTION_HANDLER;
            this.anyExceptionLabelsCount = 0;
        }
        int pc = codeStream.position;
        this.expression.generateCode(this.scope, codeStream, true);
        if (this.block.isEmptyBlock()) {
            if (this.synchroVariable.type == BaseTypes.LongBinding || this.synchroVariable.type == BaseTypes.DoubleBinding) {
                codeStream.dup2();
            } else {
                codeStream.dup();
            }
            codeStream.monitorenter();
            codeStream.monitorexit();
        } else {
            codeStream.store(this.synchroVariable, true);
            codeStream.monitorenter();
            this.enterAnyExceptionHandler(codeStream);
            this.block.generateCode(this.scope, codeStream);
            Label endLabel = new Label(codeStream);
            if (!this.blockExit) {
                codeStream.load(this.synchroVariable);
                codeStream.monitorexit();
                codeStream.goto_(endLabel);
            }
            this.exitAnyExceptionHandler();
            this.placeAllAnyExceptionHandlers();
            codeStream.incrStackSize(1);
            codeStream.load(this.synchroVariable);
            codeStream.monitorexit();
            codeStream.athrow();
            if (!this.blockExit) {
                endLabel.place();
            }
        }
        if (this.scope != currentScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateSubRoutineInvocation(BlockScope currentScope, CodeStream codeStream) {
        codeStream.load(this.synchroVariable);
        codeStream.monitorexit();
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        TypeBinding type = this.expression.resolveType(this.scope);
        if (type == null) {
            return;
        }
        switch (type.id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.scope.problemReporter().invalidTypeToSynchronize(this.expression, type);
                break;
            }
            case 6: {
                this.scope.problemReporter().illegalVoidExpression(this.expression);
                break;
            }
            case 12: {
                this.scope.problemReporter().invalidNullToSynchronize(this.expression);
            }
        }
        this.synchroVariable = new LocalVariableBinding(SecretLocalDeclarationName, type, 0, false);
        this.scope.addLocalVariable(this.synchroVariable);
        this.synchroVariable.constant = NotAConstant;
        this.expression.implicitWidening(type, type);
        this.block.resolveUsing(this.scope);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        SynchronizedStatement.printIndent(indent, output);
        output.append("synchronized (");
        this.expression.printExpression(0, output).append(')');
        output.append('\n');
        return this.block.printStatement(indent + 1, output);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, this.scope);
            this.block.traverse(visitor, this.scope);
        }
        visitor.endVisit(this, blockScope);
    }
}

