/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IndexBinaryFolder
extends IndexRequest {
    IFolder folder;

    public IndexBinaryFolder(IFolder folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals(((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            String[] paths = index.queryDocumentNames("");
            int max = paths == null ? 0 : paths.length;
            final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
            String OK = "OK";
            String DELETED = "DELETED";
            if (max == 0) {
                this.folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        if (IndexBinaryFolder.this.isCancelled) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            IFile file;
                            if (Util.isClassFileName(proxy.getName()) && (file = (IFile)proxy.requestResource()).getLocation() != null) {
                                indexedFileNames.put(file.getFullPath().toString(), file);
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
            } else {
                for (int i = 0; i < max; ++i) {
                    indexedFileNames.put(paths[i], "DELETED");
                }
                final long indexLastModified = index.getIndexFile().lastModified();
                this.folder.accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) {
                        if (IndexBinaryFolder.this.isCancelled) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            IFile file;
                            IPath location;
                            if (Util.isClassFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocation()) != null) {
                                String path;
                                indexedFileNames.put(path, indexedFileNames.get(path = file.getFullPath().toString()) == null || indexLastModified < location.toFile().lastModified() ? file : "OK");
                            }
                            return false;
                        }
                        return true;
                    }
                }, 0);
            }
            Object[] names = indexedFileNames.keyTable;
            Object[] values = indexedFileNames.valueTable;
            int length = names.length;
            for (int i = 0; i < length; ++i) {
                String name = (String)names[i];
                if (name == null) continue;
                if (this.isCancelled) {
                    boolean bl2 = false;
                    return bl2;
                }
                Object value = values[i];
                if (value == "OK") continue;
                if (value == "DELETED") {
                    this.manager.remove(name, this.containerPath);
                    continue;
                }
                this.manager.addBinary((IFile)value, this.containerPath);
            }
            this.manager.request(new SaveIndex(this.containerPath, this.manager));
        }
        catch (CoreException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            bl = false;
            return bl;
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            bl = false;
            return bl;
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

