/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceSynchronizeParticipant;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.team.ui.synchronize.SyncInfoCompareInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SyncAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException {
        IResource[] resources = this.getResourcesToSync();
        if (resources == null || resources.length == 0) {
            return;
        }
        if (SyncAction.isSingleFile(resources)) {
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), resources[0]);
        } else {
            WorkspaceSynchronizeParticipant participant = (WorkspaceSynchronizeParticipant)SubscriberParticipant.getMatchingParticipant((String)"org.eclipse.team.cvs.ui.cvsworkspace-participant", (IResource[])resources);
            if (participant == null) {
                participant = new WorkspaceSynchronizeParticipant((ISynchronizeScope)new ResourceScope(resources));
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, Policy.bind("Participant.synchronizing"), Policy.bind("Participant.synchronizingDetail", participant.getName()), (IWorkbenchSite)this.getTargetPart().getSite());
        }
    }

    public static void showSingleFileComparison(final Shell shell, final Subscriber subscriber, final IResource resource) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        subscriber.refresh(new IResource[]{resource}, 0, monitor);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            final SyncInfo info = subscriber.getSyncInfo(resource);
            if (info == null) {
                return;
            }
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (info.getKind() == 0) {
                        MessageDialog.openInformation((Shell)shell, (String)Policy.bind("SyncAction.noChangesTitle"), (String)Policy.bind("SyncAction.noChangesMessage"));
                    } else {
                        SyncInfoCompareInput input = new SyncInfoCompareInput(subscriber.getName(), info);
                        CompareUI.openCompareEditor((CompareEditorInput)input);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle((Throwable)e);
        }
        catch (InterruptedException e) {
        }
        catch (TeamException e) {
            Utils.handle((Throwable)e);
        }
    }

    public static boolean isSingleFile(IResource[] resources) {
        return resources.length == 1 && resources[0].getType() == 1;
    }

    protected IResource[] getResourcesToSync() {
        return this.getSelectedResources();
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return super.isEnabledForCVSResource(cvsResource) || cvsResource.getParent().isCVSFolder() && !cvsResource.isIgnored();
    }
}

