/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.ui.IWorkbenchPart;

public class HasProjectMetaFileOperation
extends CVSOperation {
    private ICVSRemoteFolder remoteFolder;
    private boolean metaFileExists;

    public static boolean hasMetaFile(IWorkbenchPart part, ICVSRemoteFolder remoteFolder) throws InvocationTargetException, InterruptedException {
        HasProjectMetaFileOperation op = new HasProjectMetaFileOperation(part, remoteFolder);
        op.run();
        return op.metaFileExists();
    }

    public HasProjectMetaFileOperation(IWorkbenchPart part, ICVSRemoteFolder remoteFolder) {
        super(part);
        this.remoteFolder = remoteFolder;
    }

    private boolean hasMetaFile(ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException {
        folder = (ICVSRemoteFolder)folder.forTag(this.remoteFolder.getTag());
        try {
            folder.members(monitor);
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        try {
            folder.getFile(".project");
            return true;
        }
        catch (TeamException teamException) {
            return false;
        }
    }

    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        this.metaFileExists = this.hasMetaFile(this.remoteFolder, monitor);
    }

    public boolean metaFileExists() {
        return this.metaFileExists;
    }

    protected String getTaskName() {
        return Policy.bind("HasProjectMetaFile.taskName");
    }

    public boolean canRunAsJob() {
        return false;
    }
}

