/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.XMLWriter;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesViewContentHandler;

public class RepositoryRoot
extends PlatformObject {
    public static final String[] DEFAULT_AUTO_REFRESH_FILES = new String[]{".project"};
    private static final String DEFINED_MODULE_PREFIX = "module:";
    ICVSRepositoryLocation root;
    String name;
    Map versionAndBranchTags = new HashMap();
    Map autoRefreshFiles = new HashMap();
    Map modulesCache;
    List dateTags = new ArrayList();
    static /* synthetic */ Class class$org$eclipse$team$internal$ccvs$core$ICVSRepositoryLocation;

    public RepositoryRoot(ICVSRepositoryLocation root) {
        this.root = root;
    }

    public String getName() {
        return this.name;
    }

    public ICVSRemoteFolder getRemoteFolder(String path, CVSTag tag, IProgressMonitor monitor) {
        if (RepositoryRoot.isDefinedModuleName(path)) {
            return this.getDefinedModule(RepositoryRoot.getDefinedModuleName(path), tag, monitor);
        }
        return this.root.getRemoteFolder(path, tag);
    }

    static boolean isDefinedModuleName(String path) {
        return path.startsWith(DEFINED_MODULE_PREFIX);
    }

    static String getDefinedModuleName(String path) {
        return path.substring(DEFINED_MODULE_PREFIX.length());
    }

    static String asDefinedModulePath(String path) {
        return DEFINED_MODULE_PREFIX + path;
    }

    private ICVSRemoteFolder getDefinedModule(String path, CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        ICVSRemoteFolder folder = (ICVSRemoteFolder)cache.get(path);
        if (folder != null) {
            folder = (ICVSRemoteFolder)folder.forTag(tag);
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDefinedModulesCache(CVSTag tag, IProgressMonitor monitor) {
        if (this.modulesCache == null) {
            this.modulesCache = new HashMap();
            Map map = this.modulesCache;
            synchronized (map) {
                try {
                    ICVSRemoteResource[] folders = this.root.members(CVSTag.DEFAULT, true, monitor);
                    for (int i = 0; i < folders.length; ++i) {
                        ICVSRemoteResource resource = folders[i];
                        this.modulesCache.put(resource.getName(), resource);
                    }
                }
                catch (CVSException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }
        return this.modulesCache;
    }

    public ICVSRemoteResource[] getDefinedModules(CVSTag tag, IProgressMonitor monitor) {
        Map cache = this.getDefinedModulesCache(tag, monitor);
        return cache.values().toArray(new ICVSRemoteResource[cache.size()]);
    }

    public static String getRemotePathFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSRemoteFolder remoteFolder;
            if (resource instanceof ICVSRemoteFolder && (remoteFolder = (ICVSRemoteFolder)resource).isDefinedModule()) {
                return RepositoryRoot.asDefinedModulePath(remoteFolder.getName());
            }
            FolderSyncInfo info = ((ICVSFolder)resource).getFolderSyncInfo();
            if (info == null) {
                throw new CVSException(Policy.bind("RepositoryRoot.folderInfoMissing", resource.getName()));
            }
            return info.getRepository();
        }
        FolderSyncInfo info = resource.getParent().getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(Policy.bind("RepositoryRoot.folderInfoMissing", resource.getParent().getName()));
        }
        String path = new Path(info.getRepository()).append(resource.getName()).toString();
        return path;
    }

    public ICVSRepositoryLocation getRoot() {
        return this.root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addTags(String remotePath, CVSTag[] tags) {
        this.addDateTags(tags);
        this.addVersionAndBranchTags(remotePath, tags);
    }

    private void addDateTags(CVSTag[] tags) {
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].getType() != 3) continue;
            this.dateTags.add(tags[i]);
        }
    }

    private void addVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        HashSet<CVSTag> set = (HashSet<CVSTag>)this.versionAndBranchTags.get(name);
        if (set == null) {
            set = new HashSet<CVSTag>();
            this.versionAndBranchTags.put(name, set);
        }
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].getType() == 3) continue;
            set.add(tags[i]);
        }
    }

    public void addDateTag(CVSTag tag) {
        if (!this.dateTags.contains(tag)) {
            this.dateTags.add(tag);
        }
    }

    public void removeDateTag(CVSTag tag) {
        if (this.dateTags.contains(tag)) {
            this.dateTags.remove(tag);
        }
    }

    public CVSTag[] getDateTags() {
        return this.dateTags.toArray(new CVSTag[this.dateTags.size()]);
    }

    public void removeTags(String remotePath, CVSTag[] tags) {
        this.removeDateTags(tags);
        this.removeVersionAndBranchTags(remotePath, tags);
    }

    private void removeDateTags(CVSTag[] tags) {
        if (this.dateTags.isEmpty()) {
            return;
        }
        for (int i = 0; i < tags.length; ++i) {
            this.dateTags.remove(tags[i]);
        }
    }

    private void removeVersionAndBranchTags(String remotePath, CVSTag[] tags) {
        String name = this.getCachePathFor(remotePath);
        Set set = (Set)this.versionAndBranchTags.get(name);
        if (set == null) {
            return;
        }
        for (int i = 0; i < tags.length; ++i) {
            set.remove(tags[i]);
        }
    }

    public String[] getAutoRefreshFiles(String remotePath) {
        String name = this.getCachePathFor(remotePath);
        Set files = (Set)this.autoRefreshFiles.get(name);
        if (files == null || files.isEmpty()) {
            if (RepositoryRoot.isDefinedModuleName(remotePath)) {
                return new String[0];
            }
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < DEFAULT_AUTO_REFRESH_FILES.length; ++i) {
                String relativePath = DEFAULT_AUTO_REFRESH_FILES[i];
                result.add(new Path(remotePath).append(relativePath).toString());
            }
            return result.toArray(new String[result.size()]);
        }
        return files.toArray(new String[files.size()]);
    }

    public void setAutoRefreshFiles(String remotePath, String[] autoRefreshFiles) {
        HashSet<String> newFiles = new HashSet<String>(Arrays.asList(autoRefreshFiles));
        if (autoRefreshFiles.length == DEFAULT_AUTO_REFRESH_FILES.length) {
            boolean isDefault = true;
            for (int i = 0; i < DEFAULT_AUTO_REFRESH_FILES.length; ++i) {
                String filePath = DEFAULT_AUTO_REFRESH_FILES[i];
                if (newFiles.contains(new Path(remotePath).append(filePath).toString())) continue;
                isDefault = false;
                break;
            }
            if (isDefault) {
                this.autoRefreshFiles.remove(this.getCachePathFor(remotePath));
                return;
            }
        }
        this.autoRefreshFiles.put(this.getCachePathFor(remotePath), newFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDefinedTags(String remotePath, boolean replace, IProgressMonitor monitor) throws TeamException {
        String[] filesToRefresh = this.getAutoRefreshFiles(remotePath);
        monitor.beginTask(null, filesToRefresh.length * 10);
        try {
            ArrayList<CVSTag> tags = new ArrayList<CVSTag>();
            for (int i = 0; i < filesToRefresh.length; ++i) {
                ICVSRemoteFile file = this.root.getRemoteFile(filesToRefresh[i], CVSTag.DEFAULT);
                tags.addAll(Arrays.asList(this.fetchTags(file, Policy.subMonitorFor(monitor, 5))));
            }
            if (!tags.isEmpty()) {
                this.addTags(remotePath, tags.toArray(new CVSTag[tags.size()]));
            }
        }
        finally {
            monitor.done();
        }
    }

    private CVSTag[] fetchTags(ICVSRemoteFile file, IProgressMonitor monitor) throws TeamException {
        try {
            HashSet<CVSTag> tagSet = new HashSet<CVSTag>();
            ILogEntry[] entries = file.getLogEntries(monitor);
            for (int j = 0; j < entries.length; ++j) {
                CVSTag[] tags = entries[j].getTags();
                for (int k = 0; k < tags.length; ++k) {
                    tagSet.add(tags[k]);
                }
            }
            return tagSet.toArray(new CVSTag[0]);
        }
        catch (TeamException e) {
            IStatus[] children;
            IStatus status = e.getStatus();
            if (status.getCode() == -10 && status.isMultiStatus() && (children = status.getChildren()).length == 1 && children[0].getCode() == -17) {
                return new CVSTag[0];
            }
            throw e;
        }
    }

    private String getCachePathFor(String remotePath) {
        String root = new Path(remotePath).segment(0);
        if (RepositoryRoot.isDefinedModuleName(remotePath)) {
            return RepositoryRoot.asDefinedModulePath(root);
        }
        return root;
    }

    public void writeState(XMLWriter writer) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.clear();
        attributes.put("id", this.root.getLocation());
        if (this.name != null) {
            attributes.put("name", this.name);
        }
        writer.startTag("repository", attributes, true);
        if (!this.dateTags.isEmpty()) {
            writer.startTag("date-tags", attributes, true);
            Iterator iter = this.dateTags.iterator();
            while (iter.hasNext()) {
                CVSTag tag = (CVSTag)iter.next();
                this.writeATag(writer, attributes, tag, "date-tag");
            }
            writer.endTag("date-tags");
        }
        String[] paths = this.getKnownRemotePaths();
        for (int i = 0; i < paths.length; ++i) {
            Set refreshSet;
            String path = paths[i];
            attributes.clear();
            String name = path;
            if (RepositoryRoot.isDefinedModuleName(path)) {
                name = RepositoryRoot.getDefinedModuleName(path);
                attributes.put("type", "defined");
            }
            attributes.put("path", name);
            writer.startTag("module", attributes, true);
            Set tagSet = (Set)this.versionAndBranchTags.get(path);
            if (tagSet != null) {
                Iterator tagIt = tagSet.iterator();
                while (tagIt.hasNext()) {
                    CVSTag tag = (CVSTag)tagIt.next();
                    this.writeATag(writer, attributes, tag, "tag");
                }
            }
            if ((refreshSet = (Set)this.autoRefreshFiles.get(path)) != null) {
                Iterator filenameIt = refreshSet.iterator();
                while (filenameIt.hasNext()) {
                    String filename = (String)filenameIt.next();
                    attributes.clear();
                    attributes.put("full-path", filename);
                    writer.startAndEndTag("auto-refresh-file", attributes, true);
                }
            }
            writer.endTag("module");
        }
        writer.endTag("repository");
    }

    private void writeATag(XMLWriter writer, HashMap attributes, CVSTag tag, String s) {
        attributes.clear();
        attributes.put("name", tag.getName());
        attributes.put("type", RepositoriesViewContentHandler.TAG_TYPES[tag.getType()]);
        writer.startAndEndTag(s, attributes, true);
    }

    public CVSTag[] getAllKnownTags(String remotePath) {
        Set tagSet = (Set)this.versionAndBranchTags.get(this.getCachePathFor(remotePath));
        if (tagSet != null) {
            CVSTag[] tags1 = tagSet.toArray(new CVSTag[tagSet.size()]);
            CVSTag[] tags2 = this.getDateTags();
            int len = tags1.length + tags2.length;
            CVSTag[] tags = new CVSTag[len];
            for (int i = 0; i < len; ++i) {
                tags[i] = i < tags1.length ? tags1[i] : tags2[i - tags1.length];
            }
            return tags;
        }
        return this.getDateTags();
    }

    public String[] getKnownRemotePaths() {
        HashSet paths = new HashSet();
        paths.addAll(this.versionAndBranchTags.keySet());
        paths.addAll(this.autoRefreshFiles.keySet());
        return paths.toArray(new String[paths.size()]);
    }

    public Object getAdapter(Class adapter) {
        if ((class$org$eclipse$team$internal$ccvs$core$ICVSRepositoryLocation == null ? (class$org$eclipse$team$internal$ccvs$core$ICVSRepositoryLocation = RepositoryRoot.class$("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation")) : class$org$eclipse$team$internal$ccvs$core$ICVSRepositoryLocation).equals(adapter)) {
            return this.getRoot();
        }
        return super.getAdapter(adapter);
    }

    public ICVSRemoteResource[] filterResources(ICVSRemoteResource[] resource) {
        ArrayList<ICVSRemoteFolder> result = new ArrayList<ICVSRemoteFolder>();
        for (int i = 0; i < resource.length; ++i) {
            ICVSRemoteResource remoteResource = resource[i];
            if (!(remoteResource instanceof ICVSRemoteFolder)) continue;
            ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
            if (!this.tagIsKnown(remoteResource)) continue;
            result.add(folder);
        }
        return result.toArray(new ICVSRemoteResource[result.size()]);
    }

    public boolean tagIsKnown(ICVSRemoteResource remoteResource) {
        if (remoteResource instanceof ICVSRemoteFolder) {
            ICVSRemoteFolder folder = (ICVSRemoteFolder)remoteResource;
            String path = this.getCachePathFor(folder.getRepositoryRelativePath());
            CVSTag[] tags = this.getAllKnownTags(path);
            CVSTag tag = folder.getTag();
            for (int i = 0; i < tags.length; ++i) {
                CVSTag knownTag = tags[i];
                if (!knownTag.equals((Object)tag)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        if (this.modulesCache == null) {
            return;
        }
        Map map = this.modulesCache;
        synchronized (map) {
            this.modulesCache = null;
        }
    }

    void setRepositoryLocation(ICVSRepositoryLocation root) {
        this.root = root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

