/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class ConfirmMergedOperation
extends CVSSubscriberOperation {
    public ConfirmMergedOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return Policy.bind("SubscriberConfirmMergedAction.jobName", new Integer(syncSet.size()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws CVSException {
        SyncInfo[] syncResources = syncSet.getSyncInfos();
        monitor.beginTask(null, 100 * syncResources.length);
        try {
            for (int i = 0; i < syncResources.length; ++i) {
                SyncInfo info = syncResources[i];
                if (this.makeOutgoing(info, Policy.subMonitorFor(monitor, 100))) continue;
            }
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeOutgoing(SyncInfo info, IProgressMonitor monitor) throws CVSException, TeamException {
        monitor.beginTask(null, 100);
        try {
            SyncInfo parentInfo;
            CVSSyncInfo cvsInfo = this.getCVSSyncInfo(info);
            if (cvsInfo == null) {
                CVSUIPlugin.log(4, Policy.bind("SubscriberConfirmMergedAction.0", cvsInfo.getLocal().getFullPath().toString()), null);
                boolean bl = false;
                return bl;
            }
            ICVSFolder parent = CVSWorkspaceRoot.getCVSFolderFor((IContainer)cvsInfo.getLocal().getParent());
            if (!parent.isCVSFolder() && !this.makeOutgoing(parentInfo = cvsInfo.getSubscriber().getSyncInfo(parent.getIResource()), Policy.subMonitorFor(monitor, 20))) {
                boolean bl = false;
                return bl;
            }
            IStatus status = cvsInfo.makeOutgoing(Policy.subMonitorFor(monitor, 80));
            if (status.getSeverity() == 4) {
                this.logError(status);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            monitor.done();
        }
    }
}

