/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;

public class NewLocationWizard
extends Wizard {
    private ConfigurationWizardMainPage mainPage;
    private Properties properties = null;

    public static IDialogSettings getLocationDialogSettings() {
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        return section;
    }

    public NewLocationWizard() {
        IDialogSettings section = NewLocationWizard.getLocationDialogSettings();
        this.setDialogSettings(section);
        this.setWindowTitle(Policy.bind("NewLocationWizard.title"));
    }

    public NewLocationWizard(Properties initialProperties) {
        this();
        this.properties = initialProperties;
    }

    public void addPages() {
        this.mainPage = new ConfigurationWizardMainPage("repositoryPage1", Policy.bind("NewLocationWizard.heading"), CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.gif"));
        if (this.properties != null) {
            this.mainPage.setProperties(this.properties);
        }
        this.mainPage.setShowValidate(true);
        this.mainPage.setDescription(Policy.bind("NewLocationWizard.description"));
        this.mainPage.setDialogSettings(this.getDialogSettings());
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        boolean keepLocation;
        ICVSRepositoryLocation[] location;
        block13: {
            location = new ICVSRepositoryLocation[]{null};
            keepLocation = false;
            try {
                location[0] = this.mainPage.getLocation();
                location[0] = KnownRepositories.getInstance().addRepository(location[0], false);
                if (this.mainPage.getValidate()) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    location[0].validateConnection(monitor);
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                        keepLocation = true;
                        break block13;
                    }
                    catch (InterruptedException e) {
                        break block13;
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof TeamException) {
                            throw (TeamException)t;
                        }
                        if (t instanceof Exception) {
                            throw CVSException.wrapException((Exception)((Exception)t));
                        }
                        throw CVSException.wrapException((Exception)e);
                    }
                }
                keepLocation = true;
            }
            catch (TeamException e) {
                if (location[0] == null) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.exception"), null, e);
                    return false;
                }
                IStatus error = e.getStatus();
                if (error.isMultiStatus() && error.getChildren().length == 1) {
                    error = error.getChildren()[0];
                }
                if (error.isMultiStatus()) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), Policy.bind("NewLocationWizard.validationFailedTitle"), null, e);
                }
                keepLocation = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)Policy.bind("NewLocationWizard.validationFailedTitle"), (String)Policy.bind("NewLocationWizard.validationFailedText", new Object[]{error.getMessage()}));
            }
        }
        if (keepLocation) {
            KnownRepositories.getInstance().addRepository(location[0], true);
        } else {
            KnownRepositories.getInstance().disposeRepository(location[0]);
        }
        return keepLocation;
    }
}

