/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceChangeListenerList;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.MarkerDelta;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class NotificationManager
implements IManager,
ILifecycleListener {
    private static final long NOTIFICATION_DELAY = 1500L;
    private Set avoidNotify = new HashSet();
    private long buildMarkerChangeId;
    private Map buildMarkerDeltas;
    protected boolean isNotifying;
    private ResourceDelta lastDelta;
    private long lastDeltaId;
    private ElementTree lastDeltaState;
    protected long lastNotifyDuration = 0L;
    private long lastPostBuildId = 0L;
    private ElementTree lastPostBuildTree;
    private long lastPostChangeId = 0L;
    private ElementTree lastPostChangeTree;
    private ResourceChangeListenerList listeners;
    protected boolean notificationRequested = false;
    private Job notifyJob;
    Workspace workspace;

    public NotificationManager(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ResourceChangeListenerList();
        this.notifyJob = new NotifyJob();
    }

    public void addListener(IResourceChangeListener listener, int eventMask) {
        this.listeners.add(listener, eventMask);
        EventStats.listenerAdded(listener);
    }

    public boolean beginAvoidNotify() {
        return this.avoidNotify.add(Thread.currentThread());
    }

    public void beginNotify() {
        this.notifyJob.cancel();
        this.notificationRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastChanges(ElementTree lastState, int type, boolean lockTree) throws CoreException {
        try {
            if (!this.listeners.hasListenerFor(type)) {
                return;
            }
            this.isNotifying = true;
            ResourceDelta delta = this.getDelta(lastState, type);
            if (delta == null || delta.getKind() == 0) {
                return;
            }
            long start = System.currentTimeMillis();
            this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, type, delta), lockTree);
            this.lastNotifyDuration = System.currentTimeMillis() - start;
        }
        finally {
            this.isNotifying = false;
            this.cleanUp(lastState, type);
        }
    }

    private void cleanUp(ElementTree lastState, int type) {
        boolean postChange;
        boolean bl = postChange = type == 1;
        if (postChange || type == 16) {
            long id = this.workspace.getMarkerManager().getChangeId();
            lastState.immutable();
            if (postChange) {
                this.lastPostChangeTree = lastState;
                this.lastPostChangeId = id;
            } else {
                this.lastPostBuildTree = lastState;
                this.lastPostBuildId = id;
            }
            this.workspace.getMarkerManager().resetMarkerDeltas(Math.min(this.lastPostBuildId, this.lastPostChangeId));
            this.lastDelta = null;
            this.lastDeltaState = lastState;
        }
    }

    public void broadcastChanges(IResourceChangeListener listener, int type, IResourceDelta delta) {
        ResourceChangeListenerList.ListenerEntry[] entries = new ResourceChangeListenerList.ListenerEntry[]{new ResourceChangeListenerList.ListenerEntry(listener, type)};
        this.notify(entries, new ResourceChangeEvent((Object)this.workspace, type, delta), false);
    }

    public void endAvoidNotify() {
        this.avoidNotify.remove(Thread.currentThread());
    }

    public void requestNotify() {
        if (this.isNotifying || this.avoidNotify.contains(Thread.currentThread())) {
            return;
        }
        long delay = Math.max(1500L, this.lastNotifyDuration * 10L);
        if (this.notifyJob.getState() == 0) {
            this.notifyJob.schedule(delay);
        }
    }

    protected ResourceDelta getDelta(ElementTree tree, int type) {
        boolean postChange;
        long id = this.workspace.getMarkerManager().getChangeId();
        boolean bl = postChange = type == 1;
        if (this.lastDelta != null && !ElementTree.hasChanges(tree, this.lastDeltaState, ResourceComparator.getComparator(true), true)) {
            if (id != this.lastDeltaId) {
                Map markerDeltas = this.workspace.getMarkerManager().getMarkerDeltas(this.lastPostBuildId);
                this.lastDelta.updateMarkers(markerDeltas);
            }
        } else {
            ElementTree oldTree = postChange ? this.lastPostChangeTree : this.lastPostBuildTree;
            long markerId = postChange ? this.lastPostChangeId : this.lastPostBuildId;
            this.lastDelta = ResourceDeltaFactory.computeDelta(this.workspace, oldTree, tree, (IPath)Path.ROOT, markerId + 1L);
        }
        this.lastDeltaState = tree;
        this.lastDeltaId = id;
        return this.lastDelta;
    }

    protected ResourceChangeListenerList.ListenerEntry[] getListeners() {
        return this.listeners.getListeners();
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: {
                if (!this.listeners.hasListenerFor(2)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 2, project), true);
                break;
            }
            case 64: {
                if (((Object)event.resource).equals(event.newResource)) {
                    return;
                }
            }
            case 16: {
                if (!this.listeners.hasListenerFor(4)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 4, project), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(ResourceChangeListenerList.ListenerEntry[] resourceListeners, final IResourceChangeEvent event, boolean lockTree) {
        int type = event.getType();
        boolean oldLock = this.workspace.isTreeLocked();
        if (lockTree) {
            this.workspace.setTreeLocked(true);
        }
        try {
            for (int i = 0; i < resourceListeners.length; ++i) {
                if ((type & resourceListeners[i].eventMask) == 0) continue;
                final IResourceChangeListener listener = resourceListeners[i].listener;
                if (Policy.MONITOR_LISTENERS) {
                    EventStats.startNotify(listener);
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                    }

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }
                });
                if (!Policy.MONITOR_LISTENERS) continue;
                EventStats.endNotify();
            }
        }
        finally {
            if (lockTree) {
                this.workspace.setTreeLocked(oldLock);
            }
        }
    }

    public void removeListener(IResourceChangeListener listener) {
        this.listeners.remove(listener);
        EventStats.listenerRemoved(listener);
    }

    public boolean shouldNotify() {
        return !this.isNotifying && this.notificationRequested;
    }

    public void shutdown(IProgressMonitor monitor) {
        this.listeners = new ResourceChangeListenerList();
    }

    public void startup(IProgressMonitor monitor) {
        this.lastPostBuildTree = this.lastPostChangeTree = this.workspace.getElementTree();
        this.workspace.addLifecycleListener(this);
    }

    protected void updateMarkerDeltas(Map newDeltas, long changeId) {
        if (changeId == this.buildMarkerChangeId) {
            return;
        }
        this.buildMarkerChangeId = changeId;
        this.buildMarkerDeltas = MarkerDelta.merge(this.buildMarkerDeltas, this.lastDelta.getDeltaInfo().getMarkerDeltas());
    }

    class NotifyJob
    extends Job {
        private final IWorkspaceRunnable noop = new IWorkspaceRunnable(this){
            private final /* synthetic */ NotifyJob this$1;
            {
                this.this$1 = this$1;
            }

            public void run(IProgressMonitor monitor) {
            }
        };

        public NotifyJob() {
            super(ICoreConstants.MSG_RESOURCES_UPDATING);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            NotificationManager.this.notificationRequested = true;
            try {
                NotificationManager.this.workspace.run(this.noop, null, 0, null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }
    }
}

