/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MarkerAttributeMap
implements Map {
    protected Object[] elements = null;
    protected int count = 0;
    protected static final int DEFAULT_SIZE = 16;
    protected static final int GROW_SIZE = 10;

    public MarkerAttributeMap() {
    }

    public MarkerAttributeMap(int initialCapacity) {
        this.elements = new Object[Math.max(initialCapacity * 2, 0)];
    }

    public MarkerAttributeMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public void clear() {
        this.elements = null;
        this.count = 0;
    }

    public boolean containsKey(Object key) {
        key = ((String)key).intern();
        if (this.elements == null || this.count == 0) {
            return false;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] != key) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (this.elements == null || this.count == 0) {
            return false;
        }
        for (int i = 1; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || !this.elements[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return this.toHashMap().entrySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        if (this.count != other.size()) {
            return false;
        }
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null || this.elements[i + 1].equals(other.get(this.elements[i]))) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        key = ((String)key).intern();
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] != key) continue;
            return this.elements[i + 1];
        }
        return null;
    }

    protected void grow() {
        Object[] expanded = new Object[this.elements.length + 10];
        System.arraycopy(this.elements, 0, expanded, 0, this.elements.length);
        this.elements = expanded;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null) continue;
            hash += this.elements[i].hashCode();
        }
        return hash;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Set keySet() {
        HashSet<Object> result = new HashSet<Object>(this.size());
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null) continue;
            result.add(this.elements[i]);
        }
        return result;
    }

    public Object put(Object key, Object value) {
        int i;
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return this.remove(key);
        }
        key = ((String)key).intern();
        if (this.elements == null) {
            this.elements = new Object[16];
        }
        if (this.count == 0) {
            this.elements[0] = key;
            this.elements[1] = value;
            ++this.count;
            return null;
        }
        for (i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] != key) continue;
            Object oldValue = this.elements[i + 1];
            this.elements[i + 1] = value;
            return oldValue;
        }
        if (this.elements.length <= this.count * 2) {
            this.grow();
        }
        for (i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] != null) continue;
            this.elements[i] = key;
            this.elements[i + 1] = value;
            ++this.count;
            return null;
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = map.get(key);
            this.put(key, value);
        }
    }

    public Object remove(Object key) {
        key = ((String)key).intern();
        if (this.elements == null || this.count == 0) {
            return null;
        }
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] != key) continue;
            this.elements[i] = null;
            Object result = this.elements[i + 1];
            this.elements[i + 1] = null;
            --this.count;
            return result;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    private HashMap toHashMap() {
        HashMap<Object, Object> result = new HashMap<Object, Object>(this.size());
        for (int i = 0; i < this.elements.length; i += 2) {
            if (this.elements[i] == null) continue;
            result.put(this.elements[i], this.elements[i + 1]);
        }
        return result;
    }

    public Collection values() {
        HashSet<Object> result = new HashSet<Object>(this.size());
        for (int i = 1; i < this.elements.length; i += 2) {
            if (this.elements[i] == null) continue;
            result.add(this.elements[i]);
        }
        return result;
    }
}

