/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceTreeReader;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkspaceTreeReader_2
extends WorkspaceTreeReader {
    public WorkspaceTreeReader_2(Workspace workspace) {
        super(workspace);
    }

    protected int getVersion() {
        return 67305986;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBuildersPersistentInfo(DataInputStream input, List builders, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            int builderCount = input.readInt();
            for (int i = 0; i < builderCount; ++i) {
                BuilderPersistentInfo info = new BuilderPersistentInfo();
                info.setProjectName(input.readUTF());
                info.setBuilderName(input.readUTF());
                int n = input.readInt();
                IProject[] projects = new IProject[n];
                for (int j = 0; j < n; ++j) {
                    projects[j] = this.workspace.getRoot().getProject(input.readUTF());
                }
                info.setInterestingProjects(projects);
                builders.add(info);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void readTree(IProject project, DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.reading");
            monitor.beginTask(message, 10);
            ArrayList infos = new ArrayList(5);
            this.readBuildersPersistentInfo(input, infos, Policy.subMonitorFor(monitor, 1));
            Iterator it = infos.iterator();
            while (it.hasNext()) {
                BuilderPersistentInfo info = (BuilderPersistentInfo)it.next();
                info.setProjectName(project.getName());
            }
            ElementTree[] trees = this.readTrees(project.getFullPath(), input, Policy.subMonitorFor(monitor, 8));
            this.linkBuildersToTrees(infos, trees, 0, Policy.subMonitorFor(monitor, 1));
        }
        catch (IOException e) {
            String message = Policy.bind("resources.readProjectTree");
            throw new ResourceException(567, null, message, e);
        }
        finally {
            monitor.done();
        }
    }
}

