/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class UITestApplication
implements IPlatformRunnable,
ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private TestableObject fTestableObject;

    public Object run(Object args) throws Exception {
        IPlatformRunnable application = this.getApplication((String[])args);
        Assert.assertNotNull((Object)application);
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        return application.run(args);
    }

    private IPlatformRunnable getApplication(String[] args) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getPluginRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(args));
        Assert.assertNotNull((Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IPlatformRunnable) {
            return (IPlatformRunnable)runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-product")) {
                return Platform.getProduct().getApplication();
            }
            if (!args[i].equals("-testApplication") || i >= args.length - 1) continue;
            return args[i + 1];
        }
        return DEFAULT_APP_3_0;
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(new Runnable(){

            public void run() {
                RemotePluginTestRunner.main(Platform.getCommandLineArgs());
            }
        });
        this.fTestableObject.testingFinished();
    }
}

