/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import com.sun.jdi.InvocationException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.core.IEvaluationRunnable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaDetailFormattersManager
implements IPropertyChangeListener,
IDebugEventSetListener,
ILaunchesListener {
    private static JavaDetailFormattersManager fgDefault;
    private HashMap fDetailFormattersMap;
    private HashMap fCacheMap;

    public static JavaDetailFormattersManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new JavaDetailFormattersManager();
        }
        return fgDefault;
    }

    private JavaDetailFormattersManager() {
        this.populateDetailFormattersMap();
        JDIDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.fCacheMap = new HashMap();
    }

    private void populateDetailFormattersMap() {
        String[] detailFormattersList = JavaDebugOptionsManager.parseList(JDIDebugUIPlugin.getDefault().getPreferenceStore().getString(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST));
        this.fDetailFormattersMap = new HashMap(detailFormattersList.length / 3);
        int i = 0;
        int length = detailFormattersList.length;
        while (i < length) {
            String typeName = detailFormattersList[i++];
            String snippet = detailFormattersList[i++].replace('\u0000', ',');
            boolean enabled = !"0".equals(detailFormattersList[i++]);
            this.fDetailFormattersMap.put(typeName, new DetailFormatter(typeName, snippet, enabled));
        }
    }

    public void computeValueDetail(final IJavaValue objectValue, final IJavaThread thread, final IValueDetailListener listener) {
        Runnable postEventDispatch = new Runnable(){

            public void run() {
                Runnable postEventProcess = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (1.access$000(this.this$1).isPerformingEvaluation() && 1.access$000(this.this$1).isSuspended()) {
                            1.access$200(this.this$1).detailComputed((IValue)1.access$100(this.this$1), DebugUIMessages.getString("JavaDetailFormattersManager.9"));
                        } else {
                            1.access$000(this.this$1).queueRunnable(new Runnable(this){
                                private final /* synthetic */ 2 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void run() {
                                    JavaDetailFormattersManager.access$500(1.access$400(2.access$300(this.this$2)), 1.access$100(2.access$300(this.this$2)), 1.access$000(2.access$300(this.this$2)), 1.access$200(2.access$300(this.this$2)));
                                }
                            });
                        }
                    }

                    static /* synthetic */ 1 access$300(2 x0) {
                        return x0.this$1;
                    }
                };
                JDIDebugUIPlugin.getStandardDisplay().asyncExec(postEventProcess);
            }

            static /* synthetic */ IJavaThread access$000(1 x0) {
                return x0.thread;
            }

            static /* synthetic */ IJavaValue access$100(1 x0) {
                return x0.objectValue;
            }

            static /* synthetic */ IValueDetailListener access$200(1 x0) {
                return x0.listener;
            }

            static /* synthetic */ JavaDetailFormattersManager access$400(1 x0) {
                return x0.JavaDetailFormattersManager.this;
            }
        };
        DebugPlugin.getDefault().asyncExec(postEventDispatch);
    }

    private void resolveFormatter(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
        ICompiledExpression compiledExpression = null;
        EvaluationListener evaluationListener = new EvaluationListener(value, thread, listener);
        if (value instanceof IJavaObject && !(value instanceof IJavaArray)) {
            IJavaObject objectValue = (IJavaObject)value;
            IJavaProject project = this.getJavaProject(thread);
            if (project != null) {
                JDIDebugTarget debugTarget = (JDIDebugTarget)thread.getDebugTarget();
                IAstEvaluationEngine evaluationEngine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)debugTarget);
                try {
                    compiledExpression = this.getCompiledExpression(objectValue, debugTarget, evaluationEngine);
                    if (compiledExpression != null) {
                        evaluationEngine.evaluateExpression(compiledExpression, objectValue, thread, (IEvaluationListener)evaluationListener, 128, false);
                        return;
                    }
                }
                catch (DebugException e) {
                    DebugUIPlugin.log((Throwable)e);
                    return;
                }
            }
        }
        try {
            evaluationListener.valueToString(value);
        }
        catch (DebugException e) {
            listener.detailComputed((IValue)value, e.getStatus().getMessage());
        }
    }

    private IJavaProject getJavaProject(IJavaThread thread) {
        IJavaProject project;
        Object sourceElement;
        ILaunch launch = thread.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        try {
            IStackFrame frame = thread.getTopStackFrame();
            if (frame == null) {
                return null;
            }
            sourceElement = locator.getSourceElement(frame);
        }
        catch (DebugException e) {
            DebugUIPlugin.log((Throwable)e);
            return null;
        }
        if (sourceElement instanceof IJavaElement) {
            return ((IJavaElement)sourceElement).getJavaProject();
        }
        if (sourceElement instanceof IResource && (project = JavaCore.create((IProject)((IResource)sourceElement).getProject())).exists()) {
            return project;
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                return JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public boolean hasAssociatedDetailFormatter(IJavaType type) {
        return this.getAssociatedDetailFormatter(type) != null;
    }

    public DetailFormatter getAssociatedDetailFormatter(IJavaType type) {
        String typeName;
        try {
            while (type instanceof IJavaArrayType) {
                type = ((IJavaArrayType)type).getComponentType();
            }
            if (!(type instanceof IJavaClassType)) {
                return null;
            }
            typeName = type.getName();
        }
        catch (DebugException e) {
            return null;
        }
        return (DetailFormatter)this.fDetailFormattersMap.get(typeName);
    }

    public void setAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.put(detailFormatter.getTypeName(), detailFormatter);
        this.savePreference();
    }

    private void savePreference() {
        Collection valuesList = this.fDetailFormattersMap.values();
        String[] values = new String[valuesList.size() * 3];
        int i = 0;
        Iterator iter = valuesList.iterator();
        while (iter.hasNext()) {
            DetailFormatter detailFormatter = (DetailFormatter)iter.next();
            values[i++] = detailFormatter.getTypeName();
            values[i++] = detailFormatter.getSnippet().replace(',', '\u0000');
            values[i++] = detailFormatter.isEnabled() ? "1" : "0";
        }
        String pref = JavaDebugOptionsManager.serializeList(values);
        JDIDebugUIPlugin.getDefault().getPreferenceStore().setValue(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST, pref);
        JDIDebugUIPlugin.getDefault().savePluginPreferences();
    }

    private String getDetailFormatter(IJavaClassType type) throws DebugException {
        DetailFormatter detailFormatter;
        if (type == null) {
            return null;
        }
        String typeName = type.getName();
        if (this.fDetailFormattersMap.containsKey(typeName) && (detailFormatter = (DetailFormatter)this.fDetailFormattersMap.get(typeName)).isEnabled()) {
            return detailFormatter.getSnippet();
        }
        return this.getDetailFormatter(type.getSuperclass());
    }

    private ICompiledExpression getCompiledExpression(IJavaObject javaObject, JDIDebugTarget debugTarget, IAstEvaluationEngine evaluationEngine) throws DebugException {
        IJavaClassType type = (IJavaClassType)javaObject.getJavaType();
        String typeName = type.getName();
        Key key = new Key(typeName, debugTarget);
        if (this.fCacheMap.containsKey(key)) {
            return (ICompiledExpression)this.fCacheMap.get(key);
        }
        String snippet = this.getDetailFormatter(type);
        if (snippet != null) {
            ICompiledExpression res = evaluationEngine.getCompiledExpression(snippet, javaObject);
            this.fCacheMap.put(key, res);
            return res;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IJDIPreferencesConstants.PREF_DETAIL_FORMATTERS_LIST)) {
            this.populateDetailFormattersMap();
            this.fCacheMap.clear();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            if (!(event.getSource() instanceof JDIDebugTarget) || event.getKind() != 8) continue;
            this.deleteCacheForTarget((JDIDebugTarget)event.getSource());
        }
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        for (int i = 0; i < launches.length; ++i) {
            ILaunch launch = launches[i];
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            for (int j = 0; j < debugTargets.length; ++j) {
                if (!(debugTargets[j] instanceof JDIDebugTarget)) continue;
                this.deleteCacheForTarget((JDIDebugTarget)debugTargets[j]);
            }
        }
    }

    private synchronized void deleteCacheForTarget(JDIDebugTarget debugTarget) {
        Iterator iter = this.fCacheMap.keySet().iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (key.fDebugTarget != debugTarget) continue;
            iter.remove();
        }
    }

    public void removeAssociatedDetailFormatter(DetailFormatter detailFormatter) {
        this.fDetailFormattersMap.remove(detailFormatter.getTypeName());
        this.savePreference();
    }

    static /* synthetic */ void access$500(JavaDetailFormattersManager x0, IJavaValue x1, IJavaThread x2, IValueDetailListener x3) {
        x0.resolveFormatter(x1, x2, x3);
    }

    private static class EvaluationListener
    implements IEvaluationListener {
        private static final String fgToString = "toString";
        private static final String fgToStringSignature = "()Ljava/lang/String;";
        private IJavaValue fValue;
        private IValueDetailListener fListener;
        private IJavaThread fThread;

        public EvaluationListener(IJavaValue value, IJavaThread thread, IValueDetailListener listener) {
            this.fValue = value;
            this.fThread = thread;
            this.fListener = listener;
        }

        public void evaluationComplete(IEvaluationResult result) {
            if (result.hasErrors()) {
                StringBuffer error = new StringBuffer(DebugUIMessages.getString("JavaDetailFormattersManager.Detail_formatter_error___1"));
                DebugException exception = result.getException();
                if (exception != null) {
                    Throwable throwable = exception.getStatus().getException();
                    error.append("\n\t\t");
                    if (throwable instanceof InvocationException) {
                        error.append(MessageFormat.format(DebugUIMessages.getString("JavaDetailFormattersManager.An_exception_occurred__{0}_3"), ((InvocationException)throwable).exception().referenceType().name()));
                    } else {
                        error.append(exception.getStatus().getMessage());
                    }
                } else {
                    String[] errors = result.getErrorMessages();
                    int length = errors.length;
                    for (int i = 0; i < length; ++i) {
                        error.append("\n\t\t").append(errors[i]);
                    }
                }
                this.fListener.detailComputed((IValue)this.fValue, error.toString());
            } else {
                try {
                    this.valueToString(result.getValue());
                }
                catch (DebugException e) {
                    this.fListener.detailComputed((IValue)this.fValue, e.getStatus().getMessage());
                }
            }
        }

        public void valueToString(IJavaValue objectValue) throws DebugException {
            IEvaluationRunnable eval = new IEvaluationRunnable(this, objectValue){
                private final /* synthetic */ IJavaValue val$objectValue;
                private final /* synthetic */ EvaluationListener this$0;
                {
                    this.this$0 = this$0;
                    this.val$objectValue = val$objectValue;
                }

                public void run(IJavaThread thread, IProgressMonitor monitor) throws DebugException {
                    StringBuffer result = new StringBuffer();
                    if (this.val$objectValue.getSignature() == null) {
                        result.append(DebugUIMessages.getString("JavaDetailFormattersManager.null"));
                    } else if (this.val$objectValue instanceof IJavaPrimitiveValue) {
                        this.this$0.appendJDIPrimitiveValueString(result, this.val$objectValue);
                    } else if (EvaluationListener.access$700(this.this$0) == null || !EvaluationListener.access$700(this.this$0).isSuspended()) {
                        result.append(DebugUIMessages.getString("JavaDetailFormattersManager.no_suspended_threads"));
                        this.this$0.appendJDIValueString(result, this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaArray) {
                        this.this$0.appendArrayDetail(result, (IJavaArray)this.val$objectValue);
                    } else if (this.val$objectValue instanceof IJavaObject) {
                        this.this$0.appendObjectDetail(result, (IJavaObject)this.val$objectValue);
                    } else {
                        this.this$0.appendJDIValueString(result, this.val$objectValue);
                    }
                    EvaluationListener.access$900(this.this$0).detailComputed((IValue)EvaluationListener.access$800(this.this$0), result.toString());
                }
            };
            this.fThread.runEvaluation(eval, null, 128, false);
        }

        protected void appendArrayDetail(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            IJavaClassType type;
            IJavaType[] types;
            IJavaType componentType = null;
            try {
                IJavaArrayType javaArrayType = (IJavaArrayType)arrayValue.getJavaType();
                componentType = javaArrayType.getComponentType();
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            if (!(componentType instanceof IJavaReferenceType)) {
                this.appendArrayDetailIndividually(result, arrayValue);
                return;
            }
            IJavaDebugTarget target = (IJavaDebugTarget)arrayValue.getDebugTarget();
            try {
                types = target.getJavaTypes("java.lang.Class");
            }
            catch (DebugException de) {
                types = null;
            }
            if (types != null && types.length > 0) {
                try {
                    type = (IJavaClassType)types[0];
                    IJavaValue arg = target.newValue("java.util.Arrays");
                    type.sendMessage("forName", "(Ljava/lang/String;)Ljava/lang/Class;", new IJavaValue[]{arg}, this.fThread);
                }
                catch (DebugException de) {
                    this.appendArrayDetailIndividually(result, arrayValue);
                }
            } else {
                this.appendArrayDetailIndividually(result, arrayValue);
            }
            types = null;
            types = target.getJavaTypes("java.util.Arrays");
            if (types != null && types.length > 0) {
                IJavaObject javaObject;
                type = (IJavaClassType)types[0];
                try {
                    javaObject = (IJavaObject)type.sendMessage("asList", "([Ljava/lang/Object;)Ljava/util/List;", new IJavaValue[]{arrayValue}, this.fThread);
                }
                catch (DebugException de) {
                    this.appendArrayDetailIndividually(result, arrayValue);
                    return;
                }
                this.appendObjectDetail(result, javaObject);
            } else {
                this.appendArrayDetailIndividually(result, arrayValue);
            }
        }

        private void appendArrayDetailIndividually(StringBuffer result, IJavaArray arrayValue) throws DebugException {
            IJavaValue[] arrayValues;
            result.append('[');
            try {
                arrayValues = arrayValue.getValues();
            }
            catch (DebugException de) {
                JDIDebugUIPlugin.log(de);
                result.append(de.getStatus().getMessage());
                return;
            }
            for (int i = 0; i < arrayValues.length; ++i) {
                IJavaValue value = arrayValues[i];
                if (value instanceof IJavaArray) {
                    this.appendArrayDetail(result, (IJavaArray)value);
                } else if (value instanceof IJavaObject) {
                    this.appendObjectDetail(result, (IJavaObject)value);
                } else {
                    this.appendJDIValueString(result, value);
                }
                if (i >= arrayValues.length - 1) continue;
                result.append(',');
                result.append(' ');
            }
            result.append(']');
        }

        protected void appendJDIPrimitiveValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendJDIValueString(StringBuffer result, IJavaValue value) throws DebugException {
            result.append(value.getValueString());
        }

        protected void appendObjectDetail(StringBuffer result, IJavaObject objectValue) throws DebugException {
            IJavaValue toStringValue = objectValue.sendMessage(fgToString, fgToStringSignature, null, this.fThread, false);
            if (toStringValue == null) {
                result.append(DebugUIMessages.getString("JavaDetailFormattersManager.<unknown>"));
            } else {
                this.appendJDIValueString(result, toStringValue);
            }
        }

        static /* synthetic */ IJavaThread access$700(EvaluationListener x0) {
            return x0.fThread;
        }

        static /* synthetic */ IJavaValue access$800(EvaluationListener x0) {
            return x0.fValue;
        }

        static /* synthetic */ IValueDetailListener access$900(EvaluationListener x0) {
            return x0.fListener;
        }
    }

    private static class Key {
        private String fTypeName;
        private JDIDebugTarget fDebugTarget;

        Key(String typeName, JDIDebugTarget debugTarget) {
            this.fTypeName = typeName;
            this.fDebugTarget = debugTarget;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.fTypeName != null && this.fDebugTarget != null && this.fTypeName.equals(key.fTypeName) && this.fDebugTarget.equals(key.fDebugTarget);
            }
            return false;
        }

        public int hashCode() {
            return this.fTypeName.hashCode() / 2 + this.fDebugTarget.hashCode() / 2;
        }
    }
}

