/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.Container;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;

public class JAASMemoryLoginModule
implements LoginModule,
Realm {
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected boolean debug = false;
    protected Map options = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected Principal principal = null;
    protected HashMap principals = new HashMap();
    protected Map sharedState = null;
    protected Subject subject = null;

    void addUser(String username, String password, String roles) {
        int comma;
        ArrayList<String> list = new ArrayList<String>();
        roles = roles + ",";
        while ((comma = roles.indexOf(44)) >= 0) {
            String role = roles.substring(0, comma).trim();
            list.add(role);
            roles = roles.substring(comma + 1);
        }
        GenericPrincipal principal = new GenericPrincipal(this, username, password, list);
        this.principals.put(username, principal);
    }

    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.committed = true;
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (options.get("pathname") != null) {
            this.pathname = (String)options.get("pathname");
        }
        this.load();
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler specified");
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        String username = null;
        String password = null;
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            password = new String(((PasswordCallback)callbacks[1]).getPassword());
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.toString());
        }
        this.principal = null;
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException("Username or password is incorrect");
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    public Container getContainer() {
        return null;
    }

    public void setContainer(Container container) {
    }

    public String getInfo() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public Principal authenticate(String username, String credentials) {
        return null;
    }

    public Principal authenticate(String username, byte[] credentials) {
        return null;
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        return null;
    }

    public boolean hasRole(Principal principal, String role) {
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    protected void load() {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            this.log("Cannot load configuration file " + file.getAbsolutePath());
            return;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new MemoryRuleSet());
        try {
            digester.push((Object)this);
            digester.parse(file);
        }
        catch (Exception e) {
            this.log("Error processing configuration file " + file.getAbsolutePath(), e);
            return;
        }
    }

    protected void log(String message) {
        System.out.print("JAASMemoryLoginModule: ");
        System.out.println(message);
    }

    protected void log(String message, Throwable exception) {
        this.log(message);
        exception.printStackTrace(System.out);
    }
}

