/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IAnnotationModelFactory;
import org.eclipse.core.filebuffers.IDocumentFactory;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.ExtensionsRegistry;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.JavaTextFileBuffer;
import org.eclipse.core.internal.filebuffers.ResourceTextFileBuffer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;

public class TextFileBufferManager
implements ITextFileBufferManager {
    private Map fFilesBuffers = new HashMap();
    private List fFileBufferListeners = new ArrayList();
    private ExtensionsRegistry fRegistry = new ExtensionsRegistry();
    private ISynchronizationContext fSynchronizationContext;

    public void connect(IPath location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer == null) {
            fileBuffer = this.createFileBuffer(location);
            if (fileBuffer == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("FileBufferManager.error.canNotCreateFilebuffer"), null));
            }
            fileBuffer.create(location, monitor);
            fileBuffer.connect();
            this.fFilesBuffers.put(location, fileBuffer);
            this.fireBufferCreated(fileBuffer);
        } else {
            fileBuffer.connect();
        }
    }

    public void disconnect(IPath location, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.disconnect();
            if (fileBuffer.isDisposed()) {
                this.fFilesBuffers.remove(location);
                this.fireBufferDisposed(fileBuffer);
            }
        }
    }

    private AbstractFileBuffer createFileBuffer(IPath location) {
        if (!this.isTextFile(location)) {
            return null;
        }
        if (this.isWorkspaceResource(location)) {
            return new ResourceTextFileBuffer(this);
        }
        return new JavaTextFileBuffer(this);
    }

    private boolean isWorkspaceResource(IPath location) {
        return FileBuffers.getWorkspaceFileAtLocation(location) != null;
    }

    private boolean isTextFile(IPath location) {
        return true;
    }

    public IFileBuffer getFileBuffer(IPath location) {
        location = FileBuffers.normalizeLocation(location);
        return (IFileBuffer)this.fFilesBuffers.get(location);
    }

    public ITextFileBuffer getTextFileBuffer(IPath location) {
        location = FileBuffers.normalizeLocation(location);
        return (ITextFileBuffer)this.fFilesBuffers.get(location);
    }

    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    public IDocument createEmptyDocument(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        IDocumentFactory factory = this.fRegistry.getDocumentFactory(location);
        Object document = null;
        document = factory != null ? factory.createDocument() : new Document();
        IDocumentSetupParticipant[] participants = this.fRegistry.getDocumentSetupParticipants(location);
        if (participants != null) {
            for (int i = 0; i < participants.length; ++i) {
                participants[i].setup((IDocument)document);
            }
        }
        return document;
    }

    public IAnnotationModel createAnnotationModel(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        IAnnotationModelFactory factory = this.fRegistry.getAnnotationModelFactory(location);
        if (factory != null) {
            return factory.createAnnotationModel(location);
        }
        return null;
    }

    public void addFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fFileBufferListeners.contains(listener)) {
            this.fFileBufferListeners.add(listener);
        }
    }

    public void removeFileBufferListener(IFileBufferListener listener) {
        Assert.isNotNull((Object)listener);
        this.fFileBufferListeners.remove(listener);
    }

    public void setSynchronizationContext(ISynchronizationContext context) {
        this.fSynchronizationContext = context;
    }

    public void requestSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.requestSynchronizationContext();
        }
    }

    public void releaseSynchronizationContext(IPath location) {
        Assert.isNotNull((Object)location);
        location = FileBuffers.normalizeLocation(location);
        AbstractFileBuffer fileBuffer = (AbstractFileBuffer)this.fFilesBuffers.get(location);
        if (fileBuffer != null) {
            fileBuffer.releaseSynchronizationContext();
        }
    }

    public void execute(Runnable runnable, boolean requestSynchronizationContext) {
        if (requestSynchronizationContext && this.fSynchronizationContext != null) {
            this.fSynchronizationContext.run(runnable);
        } else {
            runnable.run();
        }
    }

    protected void fireDirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.dirtyStateChanged(buffer, isDirty);
        }
    }

    protected void fireBufferContentAboutToBeReplaced(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.bufferContentAboutToBeReplaced(buffer);
        }
    }

    protected void fireBufferContentReplaced(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.bufferContentReplaced(buffer);
        }
    }

    protected void fireUnderlyingFileMoved(IFileBuffer buffer, IPath target) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.underlyingFileMoved(buffer, target);
        }
    }

    protected void fireUnderlyingFileDeleted(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.underlyingFileDeleted(buffer);
        }
    }

    protected void fireStateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.stateValidationChanged(buffer, isStateValidated);
        }
    }

    protected void fireStateChanging(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.stateChanging(buffer);
        }
    }

    protected void fireStateChangeFailed(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.stateChangeFailed(buffer);
        }
    }

    protected void fireBufferCreated(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.bufferCreated(buffer);
        }
    }

    protected void fireBufferDisposed(IFileBuffer buffer) {
        Iterator e = new ArrayList(this.fFileBufferListeners).iterator();
        while (e.hasNext()) {
            IFileBufferListener l = (IFileBufferListener)e.next();
            l.bufferDisposed(buffer);
        }
    }
}

