/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JavaAppletLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements IDebugEventSetListener {
    private static Map fgLaunchToFileMap = new HashMap();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (configuration == null) {
            this.abort(LaunchingMessages.getString("JavaAppletLaunchConfigurationDelegate.No_launch_configuration_specified_1"), null, 122);
        }
        monitor.beginTask(MessageFormat.format(LaunchingMessages.getString("JavaAppletLaunchConfigurationDelegate.Starting_Applet_{0}..._1"), configuration.getName()), 3);
        monitor.subTask(LaunchingMessages.getString("JavaAppletLaunchConfigurationDelegate.Verifying_launch_attributes..._1"));
        this.verifyMainTypeName(configuration);
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null) {
            if (mode == "debug") {
                this.abort(MessageFormat.format(LaunchingMessages.getString("JavaLocalApplicationLaunchConfigurationDelegate.0"), vm.getName()), null, 106);
            } else {
                this.abort(MessageFormat.format(LaunchingMessages.getString("JavaLocalApplicationLaunchConfigurationDelegate.1"), vm.getName()), null, 106);
            }
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = workingDir.getAbsolutePath();
        String javaPolicy = this.getJavaPolicyFile(workingDir);
        ExecutionArguments execArgs = new ExecutionArguments(this.getVMArguments(configuration), "");
        String[] classpath = this.getClasspath(configuration);
        String appletViewerClassName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer");
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(appletViewerClassName, classpath);
        File htmlFile = this.buildHTMLFile(configuration, workingDir);
        if (htmlFile == null) {
            this.abort(LaunchingMessages.getString("JavaAppletLaunchConfigurationDelegate.Could_not_build_HTML_file_for_applet_launch_1"), null, 123);
        }
        runConfig.setProgramArguments(new String[]{htmlFile.getName()});
        String[] vmArgs = execArgs.getVMArgumentsArray();
        String[] realArgs = new String[vmArgs.length + 1];
        System.arraycopy(vmArgs, 0, realArgs, 1, vmArgs.length);
        realArgs[0] = javaPolicy;
        runConfig.setVMArguments(realArgs);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setBootClassPath(this.getBootpath(configuration));
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        monitor.worked(1);
        if (fgLaunchToFileMap.isEmpty()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        fgLaunchToFileMap.put(launch, htmlFile);
        monitor.subTask(LaunchingMessages.getString("JavaAppletLaunchConfigurationDelegate.Creating_source_locator..._2"));
        this.setDefaultSourceLocator(launch, configuration);
        monitor.worked(1);
        try {
            runner.run(runConfig, launch, monitor);
        }
        catch (CoreException ce) {
            htmlFile.delete();
            throw ce;
        }
        monitor.done();
    }

    public String getJavaPolicyFile(File workingDir) {
        File file = new File(workingDir, "java.policy.applet");
        if (!file.exists()) {
            File test = LaunchingPlugin.getFileInPlugin((IPath)new Path("java.policy.applet"));
            try {
                byte[] bytes = JavaAppletLaunchConfigurationDelegate.getFileByteContent(test);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(bytes);
                outputStream.close();
            }
            catch (IOException e) {
                return "";
            }
        }
        return "-Djava.security.policy=java.policy.applet";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private File buildHTMLFile(ILaunchConfiguration configuration, File dir) {
        block18: {
            writer = null;
            tempFile = null;
            try {
                name = this.getMainTypeName(configuration);
                tempFile = new File(dir, name + System.currentTimeMillis() + ".html");
                writer = new FileWriter(tempFile);
                writer.write("<html>\n");
                writer.write("<body>\n");
                writer.write("<applet code=");
                writer.write(name);
                writer.write(".class ");
                appletName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
                if (appletName.length() != 0) {
                    writer.write("NAME =\"" + appletName + "\" ");
                }
                writer.write("width=\"");
                writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
                writer.write("\" height=\"");
                writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
                writer.write("\" >\n");
                parameters = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, new HashMap<K, V>());
                if (parameters.size() != 0) {
                    iterator = parameters.entrySet().iterator();
                    while (iterator.hasNext()) {
                        next = iterator.next();
                        writer.write("<param name=");
                        writer.write(this.getQuotedString((String)next.getKey()));
                        writer.write(" value=");
                        writer.write(this.getQuotedString((String)next.getValue()));
                        writer.write(">\n");
                    }
                }
                writer.write("</applet>\n");
                writer.write("</body>\n");
                writer.write("</html>\n");
                var11_12 = null;
                ** if (writer == null) goto lbl-1000
            }
            catch (Throwable var10_20) {
                var11_15 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var10_20;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (IOException e) {
                    var11_13 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {}
                    }
                    break block18;
                }
                catch (CoreException e) {
                    var11_14 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (tempFile == null) {
            return null;
        }
        return tempFile;
    }

    private String getQuotedString(String string) {
        if (string.indexOf(34) == -1) {
            return '\"' + string + '\"';
        }
        return '\'' + string + '\'';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        block5: for (int i = 0; i < events.length; ++i) {
            DebugEvent event = events[i];
            Object eventSource = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    Object var8_7;
                    if (eventSource == null) continue block5;
                    ILaunch launch = null;
                    if (eventSource instanceof IProcess) {
                        IProcess process = (IProcess)eventSource;
                        launch = process.getLaunch();
                    } else if (eventSource instanceof IDebugTarget) {
                        IDebugTarget debugTarget = (IDebugTarget)eventSource;
                        launch = debugTarget.getLaunch();
                    }
                    File temp = (File)fgLaunchToFileMap.get(launch);
                    if (temp == null) continue block5;
                    try {
                        fgLaunchToFileMap.remove(launch);
                        temp.delete();
                        var8_7 = null;
                        if (!fgLaunchToFileMap.isEmpty()) continue block5;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        if (fgLaunchToFileMap.isEmpty()) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        }
                        throw throwable;
                    }
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    continue block5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = JavaAppletLaunchConfigurationDelegate.getInputStreamAsByteArray(stream, (int)file.length());
                Object var4_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return byArray;
    }

    protected static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int bytesRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + available];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((bytesRead = stream.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += bytesRead;
            } while (bytesRead > 0);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            String outputDir = JavaRuntime.getProjectOutputDirectory(configuration);
            if (outputDir == null) {
                return new File(System.getProperty("user.dir"));
            }
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(outputDir);
            if (resource == null || !resource.exists()) {
                return new File(System.getProperty("user.dir"));
            }
            return resource.getLocation().toFile();
        }
        if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), path.toString()), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format(LaunchingMessages.getString("AbstractJavaLaunchConfigurationDelegate.Working_directory_does_not_exist__{0}_12"), path.toString()), null, 108);
        }
        return null;
    }
}

