/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class LaunchConfigTypeChange
extends Change {
    private IType fType;
    private ILaunchConfiguration fConfig;
    private String fNewName;

    public LaunchConfigTypeChange(IType type, ILaunchConfiguration config, String newName) {
        this.fType = type;
        this.fConfig = config;
        this.fNewName = newName;
    }

    public String getName() {
        return this.fConfig.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        String current = this.fConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, (String)null);
        int index = current.lastIndexOf(46);
        String newTypeName = index == -1 ? this.fNewName : current.substring(0, index + 1) + this.fNewName;
        ILaunchConfigurationWorkingCopy copy = this.fConfig.getWorkingCopy();
        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, newTypeName);
        String launchConfigurationName = this.fConfig.getName();
        if (launchConfigurationName.equals(current) && !DebugPlugin.getDefault().getLaunchManager().isExistingLaunchConfigurationName(this.fNewName)) {
            copy.rename(this.fNewName);
        }
        copy.doSave();
        pm.worked(1);
        return new LaunchConfigTypeChange(this.fType, this.fConfig, index == -1 ? current : current.substring(index + 1));
    }

    public Object getModifiedElement() {
        return this.fConfig;
    }
}

