/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.PessimisticResourceRuleFactory;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamHookDispatcher;
import org.eclipse.team.internal.core.TeamPlugin;

public abstract class RepositoryProvider
implements IProjectNature,
IAdaptable {
    private static final String TEAM_SETID = "org.eclipse.team.repository-provider";
    private static final QualifiedName PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");
    private static final List AllProviderTypeIds = RepositoryProvider.initializeAllProviderTypes();
    private IProject project;
    private static final ILock mappingLock = Platform.getJobManager().newLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void map(IProject project, String id) throws TeamException {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
        try {
            Platform.getJobManager().beginRule(rule, null);
            try {
                mappingLock.acquire();
                RepositoryProvider existingProvider = null;
                if (project.getPersistentProperty(PROVIDER_PROP_KEY) != null) {
                    existingProvider = RepositoryProvider.getProvider(project);
                }
                if (existingProvider != null) {
                    if (existingProvider.getID().equals(id)) {
                        return;
                    }
                    RepositoryProvider.unmap(project);
                }
                RepositoryProvider provider = RepositoryProvider.mapNewProvider(project, id);
                try {
                    project.setPersistentProperty(PROVIDER_PROP_KEY, id);
                }
                catch (CoreException outer) {
                    try {
                        project.setSessionProperty(PROVIDER_PROP_KEY, null);
                    }
                    catch (CoreException inner) {
                        TeamPlugin.log(4, Policy.bind("RepositoryProvider.couldNotClearAfterError", project.getName(), id), inner);
                    }
                    throw outer;
                }
                provider.configure();
                project.touch(null);
                TeamHookDispatcher.setProviderRuleFactory(project, provider.getRuleFactory());
            }
            finally {
                mappingLock.release();
            }
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
        finally {
            Platform.getJobManager().endRule(rule);
        }
    }

    private static RepositoryProvider mapNewProvider(IProject project, String id) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.newProvider(id);
        if (provider == null) {
            throw new TeamException(Policy.bind("RepositoryProvider.couldNotInstantiateProvider", project.getName(), id));
        }
        if (!provider.canHandleLinkedResources()) {
            try {
                IResource[] members = project.members();
                for (int i = 0; i < members.length; ++i) {
                    IResource resource = members[i];
                    if (!resource.isLinked()) continue;
                    throw new TeamException((IStatus)new Status(4, "org.eclipse.team.core", 378, Policy.bind("RepositoryProvider.linkedResourcesExist", project.getName(), id), null));
                }
            }
            catch (CoreException e) {
                throw TeamPlugin.wrapException(e);
            }
        }
        try {
            project.setSessionProperty(PROVIDER_PROP_KEY, (Object)provider);
            provider.setProject(project);
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RepositoryProvider mapExistingProvider(IProject project, String id) throws TeamException {
        try {
            block8: {
                mappingLock.acquire();
                try {
                    String currentId = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (currentId == null) {
                        RepositoryProvider repositoryProvider = null;
                        return repositoryProvider;
                    }
                    if (currentId.equals(id)) break block8;
                }
                catch (CoreException e) {
                    throw TeamPlugin.wrapException(e);
                }
                RepositoryProvider repositoryProvider = RepositoryProvider.lookupProviderProp(project);
                return repositoryProvider;
            }
            RepositoryProvider repositoryProvider = RepositoryProvider.mapNewProvider(project, id);
            return repositoryProvider;
        }
        finally {
            mappingLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmap(IProject project) throws TeamException {
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)project);
        try {
            Platform.getJobManager().beginRule(rule, null);
            try {
                mappingLock.acquire();
                String id = project.getPersistentProperty(PROVIDER_PROP_KEY);
                if (id == null) {
                    throw new TeamException(Policy.bind("RepositoryProvider.No_Provider_Registered", project.getName()));
                }
                RepositoryProvider provider = RepositoryProvider.getProvider(project);
                if (provider == null) {
                    TeamPlugin.log(4, Policy.bind("RepositoryProvider.couldNotInstantiateProvider", project.getName(), id), null);
                }
                if (provider != null) {
                    provider.deconfigure();
                }
                project.setSessionProperty(PROVIDER_PROP_KEY, null);
                project.setPersistentProperty(PROVIDER_PROP_KEY, null);
                if (provider != null) {
                    provider.deconfigured();
                }
                project.touch(null);
                TeamHookDispatcher.setProviderRuleFactory(project, null);
            }
            finally {
                mappingLock.release();
            }
        }
        catch (CoreException e) {
            throw TeamPlugin.wrapException(e);
        }
        finally {
            Platform.getJobManager().endRule(rule);
        }
    }

    private static RepositoryProvider lookupProviderProp(IProject project) throws CoreException {
        return (RepositoryProvider)project.getSessionProperty(PROVIDER_PROP_KEY);
    }

    public abstract void configureProject() throws CoreException;

    public final void configure() throws CoreException {
        try {
            this.configureProject();
        }
        catch (CoreException e) {
            try {
                RepositoryProvider.unmap(this.getProject());
            }
            catch (TeamException e2) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.core", 0, Policy.bind("RepositoryProvider_Error_removing_nature_from_project___1") + this.getID(), (Throwable)((Object)e2)));
            }
            throw e;
        }
    }

    protected void deconfigured() {
    }

    public abstract String getID();

    public IFileModificationValidator getFileModificationValidator() {
        return null;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return null;
    }

    public String toString() {
        return Policy.bind("RepositoryProvider.toString", this.getProject().getName(), this.getID());
    }

    public static final String[] getAllProviderTypeIds() {
        IProjectNatureDescriptor[] desc = ResourcesPlugin.getWorkspace().getNatureDescriptors();
        HashSet<String> teamSet = new HashSet<String>();
        teamSet.addAll(AllProviderTypeIds);
        for (int i = 0; i < desc.length; ++i) {
            String[] setIds = desc[i].getNatureSetIds();
            for (int j = 0; j < setIds.length; ++j) {
                if (!setIds[j].equals(TEAM_SETID)) continue;
                teamSet.add(desc[i].getNatureId());
            }
        }
        return teamSet.toArray(new String[teamSet.size()]);
    }

    public static final RepositoryProvider getProvider(IProject project) {
        block7: {
            try {
                if (project.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                    if (provider != null) {
                        return provider;
                    }
                    String id = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (id != null) {
                        return RepositoryProvider.mapExistingProvider(project, id);
                    }
                    IProjectDescription projectDesc = project.getDescription();
                    String[] natureIds = projectDesc.getNatureIds();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    for (int i = 0; i < natureIds.length; ++i) {
                        IProjectNatureDescriptor desc = workspace.getNatureDescriptor(natureIds[i]);
                        if (desc == null) continue;
                        String[] setIds = desc.getNatureSetIds();
                        for (int j = 0; j < setIds.length; ++j) {
                            if (!setIds[j].equals(TEAM_SETID)) continue;
                            return RepositoryProvider.getProvider(project, natureIds[i]);
                        }
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block7;
                TeamPlugin.log(e);
            }
        }
        return null;
    }

    private static boolean isAcceptableException(CoreException e) {
        return e.getStatus().getCode() == 368;
    }

    public static final RepositoryProvider getProvider(IProject project, String id) {
        block9: {
            try {
                if (project.isAccessible()) {
                    RepositoryProvider provider = RepositoryProvider.lookupProviderProp(project);
                    if (provider != null) {
                        if (provider.getID().equals(id)) {
                            return provider;
                        }
                        return null;
                    }
                    String existingID = project.getPersistentProperty(PROVIDER_PROP_KEY);
                    if (id.equals(existingID)) {
                        RepositoryProvider newProvider = RepositoryProvider.mapExistingProvider(project, id);
                        if (newProvider != null && newProvider.getID().equals(id)) {
                            return newProvider;
                        }
                        return null;
                    }
                    IProjectNatureDescriptor desc = ResourcesPlugin.getWorkspace().getNatureDescriptor(id);
                    if (desc == null) {
                        return null;
                    }
                    String[] setIds = desc.getNatureSetIds();
                    for (int i = 0; i < setIds.length; ++i) {
                        if (!setIds[i].equals(TEAM_SETID)) continue;
                        return (RepositoryProvider)project.getNature(id);
                    }
                }
            }
            catch (CoreException e) {
                if (RepositoryProvider.isAcceptableException(e)) break block9;
                TeamPlugin.log(e);
            }
        }
        return null;
    }

    public static boolean isShared(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            if (RepositoryProvider.lookupProviderProp(project) != null) {
                return true;
            }
            return project.getPersistentProperty(PROVIDER_PROP_KEY) != null;
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
            return false;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private static List initializeAllProviderTypes() {
        IExtensionPoint extension;
        ArrayList<String> allIDs = new ArrayList<String>();
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String extensionId = configElements[j].getAttribute("id");
                    allIDs.add(extensionId);
                }
            }
        }
        return allIDs;
    }

    private static RepositoryProvider newProvider(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint("repository")) != null) {
            IExtension[] extensions = extension.getExtensions();
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String extensionId = configElements[j].getAttribute("id");
                    if (extensionId == null || !extensionId.equals(id)) continue;
                    try {
                        return (RepositoryProvider)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        TeamPlugin.log(e);
                    }
                    catch (ClassCastException e) {
                        String className = configElements[j].getAttribute("class");
                        TeamPlugin.log(4, Policy.bind("RepositoryProvider.invalidClass", id, className), e);
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public IStatus validateCreateLink(IResource resource, int updateFlags, IPath location) {
        if (this.canHandleLinkedResources()) {
            return Team.OK_STATUS;
        }
        return new Status(4, "org.eclipse.team.core", 378, Policy.bind("RepositoryProvider.linkedResourcesNotSupported", this.getProject().getName(), this.getID()), null);
    }

    public boolean canHandleLinkedResources() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IResourceRuleFactory getRuleFactory() {
        return new PessimisticResourceRuleFactory();
    }
}

