/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.streams;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public class PollingInputStream
extends FilterInputStream {
    private static final boolean DEBUG = Policy.DEBUG_STREAMS;
    private int numAttempts;
    private IProgressMonitor monitor;
    private boolean cancellable;

    public PollingInputStream(InputStream in, int numAttempts, IProgressMonitor monitor) {
        super(in);
        this.numAttempts = numAttempts;
        this.monitor = monitor;
        this.cancellable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() throws IOException {
        block17: {
            boolean stop2222;
            int attempts = 0;
            try {
                this.readPendingInput();
                Object var4_2 = null;
                stop2222 = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                boolean stop2222 = false;
                while (!stop2222) {
                    try {
                        this.in.close();
                        stop2222 = true;
                    }
                    catch (InterruptedIOException e2) {
                        if (this.checkCancellation()) {
                            throw new OperationCanceledException();
                        }
                        if (++attempts == this.numAttempts) {
                            throw new InterruptedIOException(Policy.bind("PollingInputStream.closeTimeout"));
                        }
                        if (!DEBUG) continue;
                        System.out.println("close retry=" + attempts);
                    }
                }
                throw throwable;
            }
            while (!stop2222) {
                try {
                    this.in.close();
                    stop2222 = true;
                }
                catch (InterruptedIOException e2) {
                    if (this.checkCancellation()) {
                        throw new OperationCanceledException();
                    }
                    if (++attempts == this.numAttempts) {
                        throw new InterruptedIOException(Policy.bind("PollingInputStream.closeTimeout"));
                    }
                    if (!DEBUG) continue;
                    System.out.println("close retry=" + attempts);
                }
            }
            {
                break block17;
                catch (IOException e) {
                    TeamPlugin.log(4, e.getMessage(), e);
                    Object var4_3 = null;
                    stop2222 = false;
                    while (!stop2222) {
                        try {
                            this.in.close();
                            stop2222 = true;
                        }
                        catch (InterruptedIOException e2) {
                            if (this.checkCancellation()) {
                                throw new OperationCanceledException();
                            }
                            if (++attempts == this.numAttempts) {
                                throw new InterruptedIOException(Policy.bind("PollingInputStream.closeTimeout"));
                            }
                            if (!DEBUG) continue;
                            System.out.println("close retry=" + attempts);
                        }
                    }
                }
            }
        }
    }

    public int read() throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read();
            }
            catch (InterruptedIOException e) {
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public int read(byte[] buffer, int off, int len) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.read(buffer, off, len);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    public long skip(long count) throws IOException {
        int attempts = 0;
        while (true) {
            if (this.checkCancellation()) {
                throw new OperationCanceledException();
            }
            try {
                return this.in.skip(count);
            }
            catch (InterruptedIOException e) {
                if (e.bytesTransferred != 0) {
                    return e.bytesTransferred;
                }
                if (++attempts == this.numAttempts) {
                    throw new InterruptedIOException(Policy.bind("PollingInputStream.readTimeout"));
                }
                if (!DEBUG) continue;
                System.out.println("read retry=" + attempts);
                continue;
            }
            break;
        }
    }

    protected void readPendingInput() throws IOException {
        int available;
        byte[] buffer = new byte[2048];
        while ((available = this.in.available()) >= 1) {
            if (available > buffer.length) {
                available = buffer.length;
            }
            if (this.in.read(buffer, 0, available) >= 1) continue;
            break;
        }
    }

    public void setIsCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean checkCancellation() {
        if (this.cancellable) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

