/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileSearchQuery
implements ISearchQuery {
    private String fSearchString;
    private String fSearchOptions;
    private TextSearchScope fScope;
    private FileSearchResult fResult;
    private boolean fVisitDerived;

    public FileSearchQuery(TextSearchScope scope, String options, String searchString, boolean visitDerived) {
        this.fVisitDerived = visitDerived;
        this.fScope = scope;
        this.fSearchOptions = options;
        this.fSearchString = searchString;
    }

    public FileSearchQuery(TextSearchScope scope, String options, String searchString) {
        this(scope, options, searchString, false);
    }

    public boolean canRunInBackground() {
        return true;
    }

    public IStatus run(final IProgressMonitor pm) {
        final AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        ITextSearchResultCollector collector = new ITextSearchResultCollector(){

            public IProgressMonitor getProgressMonitor() {
                return pm;
            }

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) {
                IResource resource = proxy.requestResource();
                if (start < 0) {
                    start = 0;
                }
                if (length < 0) {
                    length = 0;
                }
                textResult.addMatch(FileSearchQuery.this.createMatch((IFile)resource, start, length, lineNumber));
            }

            public void done() {
            }
        };
        return new TextSearchEngine().search(SearchPlugin.getWorkspace(), this.fScope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()));
    }

    public String getLabel() {
        return SearchMessages.getString("FileSearchQuery.label");
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    private String getSearchOptions() {
        return this.fSearchOptions;
    }

    String getSingularLabel() {
        Object[] args = new String[]{FileSearchQuery.quote(this.fSearchString), this.fScope.getDescription()};
        String format = "\"{0}\" - 1 match in {1}";
        return MessageFormat.format(format, args);
    }

    String getPluralPattern() {
        Object[] args = new String[]{FileSearchQuery.quote(this.fSearchString), "{0}", this.fScope.getDescription()};
        String format = "\"{0}\" - {1} matches in {2}";
        return MessageFormat.format(format, args);
    }

    public static String quote(String searchString) {
        searchString = searchString.replaceAll("\\{", "'{'");
        return searchString.replaceAll("\\}", "'}'");
    }

    public IStatus searchInFile(final AbstractTextSearchResult result, final IProgressMonitor monitor, IFile file) {
        ITextSearchResultCollector collector = new ITextSearchResultCollector(){

            public IProgressMonitor getProgressMonitor() {
                return monitor;
            }

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) {
                IResource resource = proxy.requestResource();
                if (start < 0) {
                    start = 0;
                }
                if (length < 0) {
                    length = 0;
                }
                result.addMatch(new FileMatch((IFile)resource, start, length));
            }

            public void done() {
            }
        };
        SearchScope scope = new SearchScope("", new IResource[]{file});
        new TextSearchEngine().search(SearchPlugin.getWorkspace(), scope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()));
        return Status.OK_STATUS;
    }

    public boolean isRegexSearch() {
        return FileSearchQuery.isRegexSearch(this.getSearchOptions());
    }

    static boolean isRegexSearch(String options) {
        return options.indexOf(114) != -1;
    }

    public boolean isCaseSensitive() {
        return FileSearchQuery.isCaseSensitive(this.getSearchOptions());
    }

    static boolean isCaseSensitive(String options) {
        return options.indexOf(105) == -1;
    }

    public boolean canRerun() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    protected FileMatch createMatch(IFile file, int start, int length, int lineNumber) {
        return new FileMatch(file, start, length);
    }
}

