/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search2.internal.ui.CancelSearchAction;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchAgainAction;
import org.eclipse.search2.internal.ui.SearchDropDownAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchPageRegistry;
import org.eclipse.search2.internal.ui.text.AnnotationManagers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SearchView
extends PageBookView
implements ISearchResultViewPart,
IQueryListener {
    private static final String MEMENTO_TYPE = "view";
    private HashMap fPartsToPages = new HashMap();
    private HashMap fPagesToParts = new HashMap();
    private HashMap fSearchViewStates;
    private SearchPageRegistry fSearchViewPageService;
    private SearchDropDownAction fSearchesDropDownAction;
    private ISearchResult fCurrentSearch;
    private DummyPart fDefaultPart;
    private SearchAgainAction fSearchAgainAction;
    private CancelSearchAction fCancelAction;
    private IMemento fPageState;
    static /* synthetic */ Class class$org$eclipse$search$ui$ISearchResultPage;
    static /* synthetic */ Class class$org$eclipse$ui$progress$IWorkbenchSiteProgressService;
    static /* synthetic */ Class class$org$eclipse$ui$part$IShowInSource;

    public static void createStandardGroups(IContributionManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.removeMatches"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
        menu.add((IContributionItem)new Separator("group.search"));
    }

    public SearchView() {
        this.setTitleImage(SearchPluginImages.get("view16/"));
        this.fSearchViewPageService = new SearchPageRegistry("org.eclipse.search.searchResultViewPages", "searchResultClass", "id");
        this.fSearchViewStates = new HashMap();
    }

    protected IPage createDefaultPage(PageBook book) {
        EmptySearchView page = new EmptySearchView();
        page.createControl((Composite)book);
        this.initPage(page);
        DummyPart part = new DummyPart();
        this.fPartsToPages.put(part, page);
        this.fPagesToParts.put(page, part);
        this.fDefaultPart = part;
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPageBookViewPage page = (IPageBookViewPage)this.fPartsToPages.get(part);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        PageBookView.PageRec rec = new PageBookView.PageRec(part, (IPage)page);
        return rec;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    public void showSearchResult(ISearchResult search) {
        if (search != null) {
            InternalSearchUI.getInstance().getSearchManager().touch(search.getQuery());
        }
        ISearchResultPage page = null;
        if (search != null && (page = this.fSearchViewPageService.getExtensionObject(search, class$org$eclipse$search$ui$ISearchResultPage == null ? (class$org$eclipse$search$ui$ISearchResultPage = SearchView.class$("org.eclipse.search.ui.ISearchResultPage")) : class$org$eclipse$search$ui$ISearchResultPage)) == null) {
            String format = SearchMessages.getString("SearchView.error.noResultPage");
            String message = MessageFormat.format(format, search.getClass().getName());
            SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, message, null));
            return;
        }
        ISearchResultPage currentPage = (ISearchResultPage)this.getCurrentPage();
        Object uiState = currentPage.getUIState();
        if (this.fCurrentSearch != null && uiState != null) {
            this.fSearchViewStates.put(this.fCurrentSearch, uiState);
        }
        currentPage.setInput(null, null);
        if (page != null && page != currentPage) {
            IWorkbenchPart part = (IWorkbenchPart)this.fPagesToParts.get(page);
            if (part == null) {
                part = new DummyPart();
                this.fPagesToParts.put(page, part);
                this.fPartsToPages.put(part, page);
                page.setViewPart(this);
            }
            this.partActivated(part);
        }
        this.fCurrentSearch = search;
        if (page != null) {
            page.setInput(search, this.fSearchViewStates.get(search));
        }
        this.updateLabel();
        this.updateCancelAction();
    }

    public void updateLabel() {
        ISearchResultPage page = this.getActivePage();
        String label = "";
        if (page != null) {
            label = page.getLabel();
        }
        this.setContentDescription(label);
    }

    public ISearchResult getCurrentSearchResult() {
        return this.fCurrentSearch;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        this.initializeToolBar();
        InternalSearchUI.getInstance().getSearchManager().addQueryListener(this);
    }

    private void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        SearchView.createStandardGroups((IContributionManager)tbm);
        tbm.appendToGroup("group.search", (IAction)this.fCancelAction);
        tbm.appendToGroup("group.search", (IAction)this.fSearchesDropDownAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createActions() {
        this.fSearchesDropDownAction = new SearchDropDownAction(this);
        this.fSearchesDropDownAction.setEnabled(InternalSearchUI.getInstance().getSearchManager().getQueries().length != 0);
        this.fSearchAgainAction = new SearchAgainAction(this);
        this.fSearchAgainAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.fCancelAction = new CancelSearchAction(this);
        this.fCancelAction.setEnabled(false);
    }

    public void dispose() {
        InternalSearchUI.getInstance().getSearchManager().removeQueryListener(this);
        AnnotationManagers.searchResultActivated(this.getSite().getWorkbenchWindow(), null);
        super.dispose();
    }

    public void queryStarting(ISearchQuery query) {
        this.updateCancelAction();
    }

    public void queryFinished(ISearchQuery query) {
        this.updateCancelAction();
    }

    private void updateCancelAction() {
        ISearchResult result = this.getCurrentSearchResult();
        boolean queryRunning = false;
        if (result != null) {
            queryRunning = InternalSearchUI.getInstance().isQueryRunning(result.getQuery());
        }
        this.fCancelAction.setEnabled(queryRunning);
    }

    public void queryAdded(ISearchQuery query) {
        this.showSearchResult(query.getSearchResult());
        this.fSearchesDropDownAction.setEnabled(InternalSearchUI.getInstance().getSearchManager().getQueries().length != 0);
    }

    public void queryRemoved(ISearchQuery query) {
        InternalSearchUI.getInstance().cancelSearch(query);
        if (query.getSearchResult().equals(this.fCurrentSearch)) {
            this.showSearchResult(null);
            this.partActivated(this.fDefaultPart);
        }
        this.fSearchViewStates.remove(query.getSearchResult());
        this.fSearchesDropDownAction.disposeMenu();
        this.fSearchesDropDownAction.setEnabled(InternalSearchUI.getInstance().getSearchManager().getQueries().length != 0);
    }

    public void fillContextMenu(IMenuManager menuManager) {
        ISearchResult result = this.getCurrentSearchResult();
        if (result != null) {
            this.fSearchAgainAction.setEnabled(result.getQuery().canRerun());
            menuManager.appendToGroup("group.search", (IAction)this.fSearchAgainAction);
            MenuManager showInSubMenu = new MenuManager(SearchMessages.getString("SearchView.showIn.menu"));
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
            menuManager.appendToGroup("group.open", (IContributionItem)showInSubMenu);
        }
    }

    public void saveState(IMemento memento) {
        Iterator pages = this.fPagesToParts.keySet().iterator();
        while (pages.hasNext()) {
            ISearchResultPage page = (ISearchResultPage)pages.next();
            IMemento child = memento.createChild(MEMENTO_TYPE, page.getID());
            page.saveState(child);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        SearchView.createStandardGroups((IContributionManager)site.getActionBars().getMenuManager());
        this.fPageState = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(InternalSearchUI.FAMILY_SEARCH);
        }
    }

    protected void initPage(IPageBookViewPage page) {
        super.initPage(page);
        page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fSearchAgainAction);
        page.getSite().getActionBars().updateActionBars();
        ISearchResultPage srPage = (ISearchResultPage)page;
        IMemento memento = null;
        if (this.fPageState != null) {
            IMemento[] mementos = this.fPageState.getChildren(MEMENTO_TYPE);
            for (int i = 0; i < mementos.length; ++i) {
                if (!mementos[i].getID().equals(srPage.getID())) continue;
                memento = mementos[i];
                break;
            }
        }
        srPage.restoreState(memento);
    }

    public void setFocus() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    public ISearchResultPage getActivePage() {
        IPage page = this.getCurrentPage();
        if (page instanceof ISearchResultPage) {
            return (ISearchResultPage)page;
        }
        return null;
    }

    public IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = null;
        Object siteService = this.getSite().getAdapter(class$org$eclipse$ui$progress$IWorkbenchSiteProgressService == null ? (class$org$eclipse$ui$progress$IWorkbenchSiteProgressService = SearchView.class$("org.eclipse.ui.progress.IWorkbenchSiteProgressService")) : class$org$eclipse$ui$progress$IWorkbenchSiteProgressService);
        if (siteService != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        this.getProgressService().warnOfContentChange();
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        if (adapter == (class$org$eclipse$ui$part$IShowInSource == null ? (class$org$eclipse$ui$part$IShowInSource = SearchView.class$("org.eclipse.ui.part.IShowInSource")) : class$org$eclipse$ui$part$IShowInSource)) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, SearchView.this.getSelectionProvider().getSelection());
                }
            };
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EmptySearchView
    extends Page
    implements ISearchResultPage {
        Control fControl;
        private String fId;

        EmptySearchView() {
        }

        public void createControl(Composite parent) {
            this.fControl = new Tree(parent, 0);
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            if (this.fControl != null) {
                this.fControl.setFocus();
            }
        }

        public void setInput(ISearchResult search, Object viewState) {
        }

        public void setViewPart(ISearchResultViewPart part) {
        }

        public Object getUIState() {
            return null;
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            this.getSite().setSelectionProvider(null);
        }

        public void saveState(IMemento memento) {
        }

        public void restoreState(IMemento memento) {
        }

        public void setID(String id) {
            this.fId = id;
        }

        public String getID() {
            return this.fId;
        }

        public String getLabel() {
            return "";
        }
    }

    class DummyPart
    implements IWorkbenchPart {
        DummyPart() {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

