/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.text.AnnotationHighlighter;
import org.eclipse.search2.internal.ui.text.EditorAccessHighlighter;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.MarkerHighlighter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorAnnotationManager
implements ISearchResultListener {
    private AbstractTextSearchResult fResult;
    private IEditorPart fEditor;
    private Highlighter fHighlighter;
    public static final int HIGHLLIGHTER_ANY = 0;
    public static final int HIGHLIGHTER_MARKER = 1;
    public static final int HIGHLIGHTER_ANNOTATION = 2;
    public static final int HIGHLIGHTER_EDITOR_ACCESS = 3;
    private static int fgHighlighterType = 0;
    static /* synthetic */ Class class$org$eclipse$search$ui$text$ISearchEditorAccess;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$IAnnotationModel;
    static /* synthetic */ Class class$org$eclipse$jface$text$IDocument;

    public EditorAnnotationManager(IEditorPart editorPart) {
        this.fEditor = editorPart;
        this.fHighlighter = EditorAnnotationManager.createHighlighter(editorPart);
    }

    public static final void debugSetHighlighterType(int type) {
        fgHighlighterType = type;
    }

    void dispose() {
        this.removeAnnotations();
        if (this.fHighlighter != null) {
            this.fHighlighter.dispose();
        }
        if (this.fResult != null) {
            this.fResult.removeListener(this);
        }
    }

    public synchronized void setSearchResult(AbstractTextSearchResult result) {
        if (result == this.fResult) {
            return;
        }
        if (this.fResult != null) {
            this.removeAnnotations();
            this.fResult.removeListener(this);
        }
        this.fResult = result;
        if (this.fResult != null) {
            this.fResult.addListener(this);
            this.addAnnotations();
        }
    }

    public synchronized void searchResultChanged(SearchResultEvent e) {
        if (this.fResult == null) {
            return;
        }
        if (e instanceof MatchEvent) {
            MatchEvent me = (MatchEvent)e;
            Match[] matches = me.getMatches();
            int kind = me.getKind();
            for (int i = 0; i < matches.length; ++i) {
                this.updateMatch(matches[i], kind);
            }
        } else if (e instanceof RemoveAllEvent) {
            this.removeAnnotations();
        }
    }

    private void updateMatch(Match match, int kind) {
        IEditorMatchAdapter adapter = this.fResult.getEditorMatchAdapter();
        if (this.fEditor != null && adapter != null && adapter.isShownInEditor(match, this.fEditor)) {
            if (kind == 1) {
                this.addAnnotations(new Match[]{match});
            } else {
                this.removeAnnotations(new Match[]{match});
            }
        }
    }

    private void removeAnnotations() {
        if (this.fHighlighter != null) {
            this.fHighlighter.removeAll();
        }
    }

    private static Highlighter createHighlighter(IEditorPart editor) {
        IFile file;
        if (fgHighlighterType != 0) {
            return EditorAnnotationManager.debugCreateHighlighter(editor);
        }
        ISearchEditorAccess access = (ISearchEditorAccess)editor.getAdapter(class$org$eclipse$search$ui$text$ISearchEditorAccess == null ? (class$org$eclipse$search$ui$text$ISearchEditorAccess = EditorAnnotationManager.class$("org.eclipse.search.ui.text.ISearchEditorAccess")) : class$org$eclipse$search$ui$text$ISearchEditorAccess);
        if (access != null) {
            return new EditorAccessHighlighter(access);
        }
        IAnnotationModel model = EditorAnnotationManager.getAnnotationModel((IWorkbenchPart)editor);
        if (model != null) {
            return new AnnotationHighlighter(model, EditorAnnotationManager.getDocument((IWorkbenchPart)editor));
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            return new MarkerHighlighter(file);
        }
        return null;
    }

    private static Highlighter debugCreateHighlighter(IEditorPart editor) {
        ISearchEditorAccess access;
        if (fgHighlighterType == 2) {
            IAnnotationModel model = EditorAnnotationManager.getAnnotationModel((IWorkbenchPart)editor);
            if (model != null) {
                return new AnnotationHighlighter(model, EditorAnnotationManager.getDocument((IWorkbenchPart)editor));
            }
        } else if (fgHighlighterType == 1) {
            IFile file;
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
                return new MarkerHighlighter(file);
            }
        } else if (fgHighlighterType == 3 && (access = (ISearchEditorAccess)editor.getAdapter(class$org$eclipse$search$ui$text$ISearchEditorAccess == null ? (class$org$eclipse$search$ui$text$ISearchEditorAccess = EditorAnnotationManager.class$("org.eclipse.search.ui.text.ISearchEditorAccess")) : class$org$eclipse$search$ui$text$ISearchEditorAccess)) != null) {
            return new EditorAccessHighlighter(access);
        }
        return null;
    }

    private void addAnnotations() {
        if (this.fResult == null) {
            return;
        }
        IEditorMatchAdapter matchAdapter = this.fResult.getEditorMatchAdapter();
        if (matchAdapter == null) {
            return;
        }
        Match[] matches = matchAdapter.computeContainedMatches(this.fResult, this.fEditor);
        if (matches == null) {
            return;
        }
        this.addAnnotations(matches);
    }

    private void addAnnotations(Match[] matches) {
        if (this.fHighlighter != null) {
            this.fHighlighter.addHighlights(matches);
        }
    }

    private void removeAnnotations(Match[] matches) {
        if (this.fHighlighter != null) {
            this.fHighlighter.removeHighlights(matches);
        }
    }

    private static IAnnotationModel getAnnotationModel(IWorkbenchPart part) {
        IAnnotationModel model = null;
        model = (IAnnotationModel)part.getAdapter(class$org$eclipse$jface$text$source$IAnnotationModel == null ? (class$org$eclipse$jface$text$source$IAnnotationModel = EditorAnnotationManager.class$("org.eclipse.jface.text.source.IAnnotationModel")) : class$org$eclipse$jface$text$source$IAnnotationModel);
        if (model == null) {
            IDocumentProvider dp;
            ITextEditor textEditor = null;
            if (part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
            }
            if (textEditor != null && (dp = textEditor.getDocumentProvider()) != null) {
                model = dp.getAnnotationModel((Object)textEditor.getEditorInput());
            }
        }
        return model;
    }

    private static IDocument getDocument(IWorkbenchPart part) {
        IDocument doc = null;
        doc = (IDocument)part.getAdapter(class$org$eclipse$jface$text$IDocument == null ? (class$org$eclipse$jface$text$IDocument = EditorAnnotationManager.class$("org.eclipse.jface.text.IDocument")) : class$org$eclipse$jface$text$IDocument);
        if (doc == null) {
            IDocumentProvider dp;
            ITextEditor textEditor = null;
            if (part instanceof ITextEditor) {
                textEditor = (ITextEditor)part;
            }
            if (textEditor != null && (dp = textEditor.getDocumentProvider()) != null) {
                doc = dp.getDocument((Object)textEditor.getEditorInput());
            }
        }
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

