/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.ListenerList;

public abstract class BufferedContent
implements IContentChangeNotifier,
IStreamContentAccessor {
    byte[] fContent;
    private ListenerList fListenerList;

    protected BufferedContent() {
    }

    public InputStream getContents() throws CoreException {
        if (this.fContent != null) {
            return new ByteArrayInputStream(this.fContent);
        }
        return this.createStream();
    }

    protected abstract InputStream createStream() throws CoreException;

    public void setContent(byte[] contents) {
        this.fContent = contents;
        this.fireContentChanged();
    }

    public byte[] getContent() {
        if (this.fContent == null) {
            try {
                InputStream is = this.createStream();
                this.fContent = Utilities.readBytes(is);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fContent;
    }

    public void discardBuffer() {
        this.fContent = null;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    protected void fireContentChanged() {
        if (this.fListenerList != null) {
            Object[] listeners = this.fListenerList.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                ((IContentChangeListener)listeners[i]).contentChanged(this);
            }
        }
    }
}

