/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;

class LineReader {
    private boolean fHaveChar = false;
    private int fLastChar;
    private boolean fSawEOF = false;
    private BufferedReader fReader;
    private boolean fIgnoreSingleCR = false;

    LineReader(BufferedReader reader) {
        this.fReader = reader;
        Assert.isNotNull((Object)reader);
    }

    void ignoreSingleCR() {
        this.fIgnoreSingleCR = true;
    }

    String readLine() throws IOException {
        StringBuffer sb = null;
        while (!this.fSawEOF) {
            int c = this.readChar();
            if (c == -1) {
                this.fSawEOF = true;
                break;
            }
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append((char)c);
            if (c == 10) break;
            if (c != 13) continue;
            c = this.readChar();
            if (c == -1) {
                this.fSawEOF = true;
                break;
            }
            if (c != 10) {
                if (this.fIgnoreSingleCR) {
                    sb.append((char)c);
                    continue;
                }
                this.fHaveChar = true;
                this.fLastChar = c;
                break;
            }
            sb.append((char)c);
            break;
        }
        if (sb != null) {
            return sb.toString();
        }
        return null;
    }

    void close() {
        try {
            this.fReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List readLines() {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = this.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException iOException) {
        }
        finally {
            this.close();
        }
        return null;
    }

    int lineContentLength(String line) {
        char c;
        if (line == null) {
            return 0;
        }
        int length = line.length();
        for (int i = length - 1; i >= 0 && ((c = line.charAt(i)) == '\n' || c == '\r'); --i) {
            --length;
        }
        return length;
    }

    private int readChar() throws IOException {
        if (this.fHaveChar) {
            this.fHaveChar = false;
            return this.fLastChar;
        }
        return this.fReader.read();
    }
}

