/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.sourcelookup.containers;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;

public abstract class ContainerSourceContainer
extends CompositeSourceContainer {
    private IContainer fContainer = null;
    private boolean fSubfolders = false;

    public ContainerSourceContainer(IContainer container, boolean subfolders) {
        this.fContainer = container;
        this.fSubfolders = subfolders;
    }

    public IContainer getContainer() {
        return this.fContainer;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        Path path;
        ArrayList<Object> sources = new ArrayList<Object>();
        IContainer container = this.getContainer();
        IFile file = container.getFile((IPath)(path = new Path(name)));
        if (file.exists()) {
            sources.add(file);
        }
        if (this.isFindDuplicates() && this.fSubfolders || sources.isEmpty() && this.fSubfolders) {
            ISourceContainer[] containers = this.getSourceContainers();
            for (int i = 0; i < containers.length; ++i) {
                Object[] objects = containers[i].findSourceElements(name);
                if (objects == null || objects.length == 0) continue;
                if (this.isFindDuplicates()) {
                    for (int j = 0; j < objects.length; ++j) {
                        sources.add(objects[j]);
                    }
                    continue;
                }
                sources.add(objects[0]);
                break;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    public String getName() {
        return this.getContainer().getName();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ContainerSourceContainer) {
            ContainerSourceContainer loc = (ContainerSourceContainer)obj;
            return loc.getContainer().equals(this.getContainer());
        }
        return false;
    }

    public int hashCode() {
        return this.getContainer().hashCode();
    }

    public boolean isComposite() {
        return this.fSubfolders;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        if (this.fSubfolders) {
            IResource[] resources = this.getContainer().members();
            ArrayList<FolderSourceContainer> list = new ArrayList<FolderSourceContainer>(resources.length);
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                if (resource.getType() != 2) continue;
                list.add(new FolderSourceContainer((IContainer)((IFolder)resource), this.fSubfolders));
            }
            ISourceContainer[] containers = list.toArray(new ISourceContainer[list.size()]);
            for (int i = 0; i < containers.length; ++i) {
                ISourceContainer container = containers[i];
                container.init(this.getDirector());
            }
            return containers;
        }
        return new ISourceContainer[0];
    }
}

