/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.keys;

import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.ui.keys.NaturalKey;

public final class CharacterKey
extends NaturalKey {
    static SortedMap characterKeysByName = new TreeMap();
    private static final CharacterKey[] CACHE = new CharacterKey[256];
    private static final char BS_CHARACTER = '\b';
    public static final CharacterKey BS = CharacterKey.getInstance('\b');
    private static final String BS_NAME = "BS";
    private static final char CR_CHARACTER = '\r';
    public static final CharacterKey CR = CharacterKey.getInstance('\r');
    private static final String CR_NAME = "CR";
    private static final char DEL_CHARACTER = '\u007f';
    public static final CharacterKey DEL = CharacterKey.getInstance('\u007f');
    private static final String DEL_NAME = "DEL";
    private static final char ESC_CHARACTER = '\u001b';
    public static final CharacterKey ESC = CharacterKey.getInstance('\u001b');
    private static final String ESC_NAME = "ESC";
    private static final char FF_CHARACTER = '\f';
    public static final CharacterKey FF = CharacterKey.getInstance('\f');
    private static final String FF_NAME = "FF";
    private static final char LF_CHARACTER = '\n';
    public static final CharacterKey LF = CharacterKey.getInstance('\n');
    private static final String LF_NAME = "LF";
    private static final char NUL_CHARACTER = '\u0000';
    public static final CharacterKey NUL = CharacterKey.getInstance('\u0000');
    private static final String NUL_NAME = "NUL";
    private static final char SPACE_CHARACTER = ' ';
    public static final CharacterKey SPACE = CharacterKey.getInstance(' ');
    private static final String SPACE_NAME = "SPACE";
    private static final char TAB_CHARACTER = '\t';
    public static final CharacterKey TAB = CharacterKey.getInstance('\t');
    private static final String TAB_NAME = "TAB";
    private static final char VT_CHARACTER = '\u000b';
    public static final CharacterKey VT = CharacterKey.getInstance('\u000b');
    private static final String VT_NAME = "VT";
    private final char character;

    public static CharacterKey getInstance(char character) {
        String name;
        switch (character) {
            case '\b': {
                name = BS_NAME;
                break;
            }
            case '\r': {
                name = CR_NAME;
                break;
            }
            case '\u007f': {
                name = DEL_NAME;
                break;
            }
            case '\u001b': {
                name = ESC_NAME;
                break;
            }
            case '\f': {
                name = FF_NAME;
                break;
            }
            case '\n': {
                name = LF_NAME;
                break;
            }
            case '\u0000': {
                name = NUL_NAME;
                break;
            }
            case ' ': {
                name = SPACE_NAME;
                break;
            }
            case '\t': {
                name = TAB_NAME;
                break;
            }
            case '\u000b': {
                name = VT_NAME;
                break;
            }
            default: {
                name = Character.toString(character);
            }
        }
        if (character < CACHE.length) {
            CharacterKey characterKey = CACHE[character];
            if (characterKey == null) {
                CharacterKey.CACHE[character] = characterKey = new CharacterKey(character, name);
            }
            return characterKey;
        }
        return new CharacterKey(character, name);
    }

    private CharacterKey(char character, String name) {
        super(name);
        this.character = character;
    }

    public char getCharacter() {
        return this.character;
    }

    static {
        characterKeysByName.put(BS.toString(), BS);
        characterKeysByName.put(CR.toString(), CR);
        characterKeysByName.put(DEL.toString(), DEL);
        characterKeysByName.put(ESC.toString(), ESC);
        characterKeysByName.put(FF.toString(), FF);
        characterKeysByName.put(LF.toString(), LF);
        characterKeysByName.put(NUL.toString(), NUL);
        characterKeysByName.put(SPACE.toString(), SPACE);
        characterKeysByName.put(TAB.toString(), TAB);
        characterKeysByName.put(VT.toString(), VT);
    }
}

