/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.internal.intro.impl.IIntroConstants;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.IntroURLParser;
import org.eclipse.ui.internal.intro.impl.swt.PageContentForm;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;
import org.eclipse.ui.internal.intro.impl.util.DialogUtil;
import org.eclipse.ui.internal.intro.impl.util.Util;

public class PageForm
implements IIntroConstants {
    protected FormToolkit toolkit;
    private ScrolledPageBook categoryPageBook;
    protected IntroModelRoot model;
    private Form parentForm;
    protected Form pageForm;
    private SharedStyleManager sharedStyleManager;
    public static String PAGE_FORM_ID = "pageFormId";
    protected HyperlinkAdapter hyperlinkAdapter = new HyperlinkAdapter(){

        public void linkActivated(HyperlinkEvent e) {
            String url = (String)e.getHref();
            IntroURLParser parser = new IntroURLParser(url);
            if (parser.hasIntroUrl()) {
                parser.getIntroURL().execute();
                return;
            }
            if (parser.hasProtocol()) {
                Util.openBrowser(url);
                return;
            }
            DialogUtil.displayInfoMessage(((Control)e.getSource()).getShell(), IntroPlugin.getString("HyperlinkAdapter.urlIs") + " " + url);
        }

        public void linkEntered(HyperlinkEvent e) {
        }

        public void linkExited(HyperlinkEvent e) {
        }
    };

    public PageForm(FormToolkit toolkit, IntroModelRoot modelRoot, Form parentForm) {
        this.toolkit = toolkit;
        this.model = modelRoot;
        this.parentForm = parentForm;
    }

    public void createPartControl(ScrolledPageBook mainPageBook, SharedStyleManager sharedStyleManager) {
        this.sharedStyleManager = sharedStyleManager;
        this.pageForm = this.toolkit.createForm(mainPageBook.getContainer());
        mainPageBook.registerPage((Object)this.getId(), (Control)this.pageForm);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.pageForm.getBody().setLayout((Layout)layout);
        this.categoryPageBook = this.toolkit.createPageBook(this.pageForm.getBody(), 768);
        this.categoryPageBook.setLayoutData((Object)new GridData(1808));
    }

    protected String getId() {
        return PAGE_FORM_ID;
    }

    public void showPage(AbstractIntroPage page, SharedStyleManager sharedStyleManager) {
        if (!this.categoryPageBook.hasPage((Object)page.getId())) {
            PageContentForm categoryForm = new PageContentForm(this.toolkit, this.model, page);
            PageStyleManager styleManager = new PageStyleManager(page, sharedStyleManager.getProperties());
            categoryForm.createPartControl(this.categoryPageBook, styleManager);
        }
        this.categoryPageBook.showPage((Object)page.getId());
        Composite pageComposite = (Composite)this.categoryPageBook.getCurrentPage();
        this.parentForm.setText(this.model.getCurrentPage().getTitle());
        this.pageForm.setText((String)pageComposite.getData("PageSubtitle"));
    }

    public boolean hasPage(String pageId) {
        return this.categoryPageBook.hasPage((Object)pageId);
    }
}

