/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.markers.internal.DeferredQueue;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.RestartableJob;
import org.eclipse.ui.views.markers.internal.TableSorter;

class TableContentProvider
implements IStructuredContentProvider {
    private static final String TABLE_SYNCHRONIZATION = Messages.getString("TableContentProvider.TableSynchronization");
    private static final String UPDATING_TABLE_WIDGET = Messages.getString("TableContentProvider.Updating");
    private String description = "";
    private TableSorter sortOrder = null;
    private DeferredQueue queues;
    private Job disableUpdatesJob = new WorkbenchJob(TABLE_SYNCHRONIZATION){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.controlExists()) {
                TableContentProvider.this.getViewer().getTable().setRedraw(false);
            }
            return Status.OK_STATUS;
        }
    };
    private Job enableUpdatesJob = new WorkbenchJob(TABLE_SYNCHRONIZATION){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.controlExists()) {
                TableContentProvider.this.getViewer().getTable().setRedraw(true);
            }
            return Status.OK_STATUS;
        }
    };
    WidgetRefreshJob uiJob;
    RestartableJob updateJob;
    private ILock lock;

    public TableContentProvider(TableViewer viewer, String description, IWorkbenchSiteProgressService service) {
        this.queues = new DeferredQueue(viewer);
        this.description = description;
        this.uiJob = new WidgetRefreshJob(UPDATING_TABLE_WIDGET);
        this.uiJob.setPriority(30);
        this.uiJob.setSystem(true);
        this.updateJob = new RestartableJob(TABLE_SYNCHRONIZATION, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TableContentProvider.this.doUpdate(monitor);
            }
        }, service);
        this.lock = Platform.getJobManager().newLock();
    }

    public void setSorter(TableSorter c) {
        if (this.sortOrder != c) {
            this.sortOrder = c;
            this.scheduleUpdate();
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.queues.getVisibleItems();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer inputViewer, Object oldInput, Object newInput) {
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Collection newVisibleItems, IProgressMonitor mon) {
        this.lock.acquire();
        try {
            this.queues.set(newVisibleItems, mon);
            this.scheduleUpdate();
        }
        finally {
            this.lock.release();
        }
    }

    private void resync() {
        int count;
        if (this.controlExists() && (count = this.queues.getViewer().getTable().getItemCount()) != this.queues.countVisibleItems()) {
            this.queues.getViewer().refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void change(Collection changes) {
        this.lock.acquire();
        try {
            this.queues.change(changes);
            this.scheduleUpdate();
        }
        finally {
            this.lock.release();
        }
    }

    private TableViewer getViewer() {
        return this.queues.getViewer();
    }

    private boolean controlExists() {
        Control control = this.getViewer().getControl();
        return control != null && !control.isDisposed();
    }

    public boolean hasPendingChanges() {
        return this.queues.hasPendingChanges() || this.sortOrder != this.queues.getSorter();
    }

    private int totalWork() {
        return this.queues.workRemaining() + 1;
    }

    private void scheduleUpdate() {
        if (this.hasPendingChanges()) {
            this.updateJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingChanges() {
        this.updateJob.cancel();
        this.lock.acquire();
        try {
            this.queues.cancelPending();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(IProgressMonitor monitor) throws InterruptedException {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        int remainingWorkUnits = 100000;
        monitor.beginTask(this.description, remainingWorkUnits);
        this.disableUpdatesJob.schedule();
        this.disableUpdatesJob.join();
        try {
            while (this.hasPendingChanges() && !monitor.isCanceled()) {
                try {
                    int totalWork;
                    this.lock.acquire();
                    try {
                        totalWork = this.totalWork();
                        if (this.sortOrder != this.queues.getSorter()) {
                            this.queues.setComparator(this.sortOrder);
                        }
                        SubProgressMonitor sub = new SubProgressMonitor(monitor, 0);
                        this.queues.refreshQueues((IProgressMonitor)sub);
                    }
                    finally {
                        this.lock.release();
                    }
                    try {
                        this.uiJob.schedule();
                        this.uiJob.join();
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                    int consumedUnits = this.uiJob.lastWorked * remainingWorkUnits / totalWork;
                    monitor.worked(consumedUnits);
                    remainingWorkUnits -= consumedUnits;
                }
                catch (InterruptedException e) {
                    monitor.setCanceled(true);
                }
                if (this.uiJob.controlExists) continue;
                break;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (PlatformUI.isWorkbenchRunning()) {
                this.enableUpdatesJob.schedule();
                this.enableUpdatesJob.join();
            }
            monitor.done();
            throw throwable;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            this.enableUpdatesJob.schedule();
            this.enableUpdatesJob.join();
        }
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateViewer() {
        int result;
        this.lock.acquire();
        try {
            if (this.getViewer().getSorter() != null) {
                this.getViewer().setSorter(null);
            }
            this.resync();
            result = this.queues.nextUpdate();
        }
        finally {
            this.lock.release();
        }
        return result;
    }

    private class WidgetRefreshJob
    extends WorkbenchJob {
        int lastWorked = 0;
        boolean controlExists = true;

        WidgetRefreshJob(String title) {
            super(title);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TableContentProvider.this.lock.getDepth() > 0) {
                this.lastWorked = 0;
                return Status.OK_STATUS;
            }
            TableContentProvider.this.lock.acquire();
            try {
                if (!PlatformUI.isWorkbenchRunning()) {
                    this.controlExists = false;
                } else {
                    this.controlExists = TableContentProvider.this.controlExists();
                    if (this.controlExists) {
                        this.lastWorked = TableContentProvider.this.updateViewer();
                    }
                }
            }
            finally {
                TableContentProvider.this.lock.release();
            }
            return Status.OK_STATUS;
        }
    }
}

