/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.eclipse.pde.internal.core.plugin.PluginObject;

public abstract class PluginParent
extends IdentifiablePluginObject
implements IPluginParent {
    protected Vector children = new Vector();

    public void add(int index, IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.children.add(index, child);
        this.postAdd(child);
    }

    public void add(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.children.add(child);
        this.postAdd(child);
    }

    void appendChild(IPluginElement child) {
        this.children.add(child);
    }

    protected void postAdd(IPluginObject child) {
        ((PluginObject)child).setInTheModel(true);
        ((PluginObject)child).setParent(this);
        this.fireStructureChanged(child, 1);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginParent) {
            IPluginParent target = (IPluginParent)obj;
            if (target.getChildCount() != this.getChildCount()) {
                return false;
            }
            IPluginObject[] tchildren = target.getChildren();
            for (int i = 0; i < tchildren.length; ++i) {
                IPluginObject tchild = tchildren[i];
                if (tchild.equals(this.children.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getIndexOf(IPluginObject child) {
        return this.children.indexOf(child);
    }

    public void swap(IPluginObject child1, IPluginObject child2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.children.indexOf(child1);
        int index2 = this.children.indexOf(child2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECore.getResourceString("PluginParent.siblingsNotFoundException"));
        }
        this.children.setElementAt(child1, index2);
        this.children.setElementAt(child2, index1);
        this.firePropertyChanged(this, "sibling_order", child1, child2);
    }

    public IPluginObject[] getChildren() {
        Object[] result = new IPluginObject[this.children.size()];
        this.children.copyInto(result);
        return result;
    }

    public void remove(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.children.removeElement(child);
        ((PluginObject)child).setInTheModel(false);
        this.fireStructureChanged(child, 2);
    }

    public void reconnect() {
        for (int i = 0; i < this.children.size(); ++i) {
            PluginObject child = (PluginObject)this.children.get(i);
            child.setModel(this.getModel());
            child.setParent(this);
            if (!(child instanceof PluginParent)) continue;
            ((PluginParent)child).reconnect();
        }
    }
}

