/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.site.AbstractSiteModel;
import org.eclipse.pde.internal.core.site.Site;

public class WorkspaceSiteModel
extends AbstractSiteModel
implements IEditableModel {
    private boolean fDirty;
    private IFile file;
    private boolean editable = true;

    public WorkspaceSiteModel() {
    }

    public WorkspaceSiteModel(IFile file) {
        this.setFile(file);
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    protected NLResourceHelper createNLResourceHelper() {
        try {
            IPath path = this.file.getLocation().removeLastSegments(1);
            String installLocation = path.toOSString();
            if (!installLocation.startsWith("file:")) {
                installLocation = "file:" + installLocation;
            }
            URL url = new URL(installLocation + "/");
            String name = "site";
            NLResourceHelper helper = new NLResourceHelper(name, new URL[]{url});
            return helper;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.loaded = true;
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return swriter.toString();
    }

    public IFile getFile() {
        return this.file;
    }

    public String getInstallLocation() {
        return this.file.getParent().getLocation().toOSString();
    }

    public IResource getUnderlyingResource() {
        return this.file;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isInSync() {
        return this.isInSync(this.file.getLocation().toFile());
    }

    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    public void load() {
        if (this.file == null) {
            return;
        }
        if (this.file.exists()) {
            boolean outOfSync = false;
            InputStream stream = null;
            try {
                stream = this.file.getContents(false);
            }
            catch (CoreException e) {
                outOfSync = true;
                try {
                    stream = this.file.getContents(true);
                }
                catch (CoreException ex) {
                    return;
                }
            }
            try {
                this.load(stream, outOfSync);
                stream.close();
            }
            catch (CoreException e) {
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.site = new Site();
            this.site.model = this;
            this.loaded = true;
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.file.exists()) {
                this.file.setContents((InputStream)stream, false, false, null);
            } else {
                this.file.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.site.write("", writer);
        }
        this.setDirty(false);
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }
}

