/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.Path;

public class PluginPathFinder {
    public static File[] getLinkFiles(String platformHome) {
        File file = new File(platformHome + '/' + "links");
        File[] linkFiles = null;
        if (file.exists() && file.isDirectory()) {
            linkFiles = file.listFiles();
        }
        return linkFiles;
    }

    public static String getPath(String platformHome, File file) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
            String path = properties.getProperty("path");
            if (path != null) {
                if (!new Path(path).isAbsolute()) {
                    path = prefix + '/' + path;
                }
                if (new File(path = path + "/eclipse").exists()) {
                    return path;
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public static String[] getPluginPaths(String platformHome) {
        ArrayList<String> result = new ArrayList<String>();
        File[] linkFiles = PluginPathFinder.getLinkFiles(platformHome);
        if (linkFiles != null) {
            for (int i = 0; i < linkFiles.length; ++i) {
                String path = PluginPathFinder.getPath(platformHome, linkFiles[i]);
                if (path == null) continue;
                result.add(path);
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

