/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.plugin.Fragment;
import org.eclipse.pde.internal.core.plugin.Plugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureReferencePage;
import org.eclipse.pde.internal.ui.editor.feature.NewFeatureRequireWizardPage;
import org.eclipse.pde.internal.ui.editor.feature.ReferenceWizard;
import org.eclipse.pde.internal.ui.editor.feature.RequiredFeaturesWizard;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class RequiresSection
extends TableSection
implements IModelProviderListener {
    public static final int MULTI_SELECTION = 33;
    private static final String KEY_TITLE = "FeatureEditor.RequiresSection.title";
    private static final String KEY_DESC = "FeatureEditor.RequiresSection.desc";
    private static final String KEY_NEW_PLUGIN_BUTTON = "FeatureEditor.RequiresSection.plugin";
    private static final String KEY_NEW_FEATURE_BUTTON = "FeatureEditor.RequiresSection.feature";
    private static final String KEY_SYNC_BUTTON = "FeatureEditor.RequiresSection.sync";
    private static final String KEY_COMPUTE = "FeatureEditor.RequiresSection.compute";
    private static final String KEY_DELETE = "Actions.delete.label";
    private Button syncButton;
    private TableViewer pluginViewer;
    private Action deleteAction;

    public RequiresSection(FeatureReferencePage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEPlugin.getResourceString(KEY_NEW_PLUGIN_BUTTON), PDEPlugin.getResourceString(KEY_NEW_FEATURE_BUTTON), null, PDEPlugin.getResourceString(KEY_COMPUTE)});
        this.getSection().setText(PDEPlugin.getResourceString(KEY_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.syncButton = toolkit.createButton(container, PDEPlugin.getResourceString(KEY_SYNC_BUTTON), 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.syncButton.setLayoutData((Object)gd);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.pluginViewer = tablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new ImportContentProvider());
        this.pluginViewer.setSorter(ListUtil.NAME_SORTER);
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.deleteAction = new Action(){

            public void run() {
                RequiresSection.this.handleDelete();
            }
        };
        this.deleteAction.setText(PDEPlugin.getResourceString(KEY_DELETE));
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewPlugin();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.recomputeImports();
            }
        }
    }

    private void handleNewPlugin() {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewFeatureRequireWizardPage page = new NewFeatureRequireWizardPage(model);
                ReferenceWizard wizard = new ReferenceWizard(model, page);
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        });
    }

    private void handleNewFeature() {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                RequiredFeaturesWizard wizard = new RequiredFeaturesWizard(model);
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            }
        });
    }

    private void handleDelete() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IStructuredSelection selection = (IStructuredSelection)this.pluginViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            IFeatureImport[] deleted = new IFeatureImport[selection.size()];
            int i = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                IFeatureImport iimport = (IFeatureImport)iter.next();
                deleted[i++] = iimport;
            }
            feature.removeImports(deleted);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.pluginViewer.getContentProvider();
        Object[] elements = provider.getElements(this.pluginViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.pluginViewer.setSelection((ISelection)ssel);
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.removeModelProviderListener((IModelProviderListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    RequiresSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.pluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    RequiresSection.this.handleSelectAll();
                }
            });
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        if (object instanceof IFeatureImport) {
            StructuredSelection ssel = new StructuredSelection(object);
            this.pluginViewer.setSelection((ISelection)ssel);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        StructuredSelection selection = (StructuredSelection)this.pluginViewer.getSelection();
        if (!selection.isEmpty()) {
            manager.add((IAction)this.deleteAction);
            manager.add((IContributionItem)new Separator());
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.getPage().getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)selection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
            this.getTablePart().setButtonEnabled(3, false);
            this.syncButton.setEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        mng.addModelProviderListener((IModelProviderListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3) {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                this.pluginViewer.refresh(obj);
            }
        } else {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                if (e.getChangeType() == 1) {
                    this.pluginViewer.add(e.getChangedObjects());
                } else {
                    this.pluginViewer.remove(e.getChangedObjects());
                }
            } else if (obj instanceof IFeaturePlugin && this.syncButton.getSelection()) {
                this.recomputeImports();
            }
        }
    }

    private void recomputeImports() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        try {
            feature.computeImports();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void modelsChanged(IModelProviderEvent event) {
        IModel[] added = event.getAddedModels();
        IModel[] removed = event.getRemovedModels();
        IModel[] changed = event.getChangedModels();
        if (this.hasPluginModels(added) || this.hasPluginModels(removed) || this.hasPluginModels(changed)) {
            this.markStale();
        }
    }

    private boolean hasPluginModels(IModel[] models) {
        if (models == null) {
            return false;
        }
        if (models.length == 0) {
            return false;
        }
        for (int i = 0; i < models.length; ++i) {
            if (!(models[i] instanceof IPluginModelBase)) continue;
            return true;
        }
        return false;
    }

    public void setFocus() {
        if (this.pluginViewer != null) {
            this.pluginViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.pluginViewer.setInput((Object)feature);
        super.refresh();
    }

    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    protected boolean canPaste(Object target, Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof FeatureImport) continue;
            return false;
        }
        return true;
    }

    protected void doPaste() {
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && this.canPaste(null, objects)) {
            this.doPaste(null, objects);
        }
    }

    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureImport[] imports = new IFeatureImport[objects.length];
        try {
            for (int i = 0; i < objects.length; ++i) {
                FeatureImport fImport = (FeatureImport)objects[i];
                fImport.setModel(model);
                fImport.setParent((IFeatureObject)feature);
                this.reconnectReference(fImport);
                imports[i] = fImport;
            }
            feature.addImports(imports);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void reconnectReference(FeatureImport fImport) {
        if (fImport.getType() == 1) {
            fImport.setFeature(PDECore.getDefault().findFeature(fImport.getId(), fImport.getVersion(), fImport.getMatch()));
        } else {
            Plugin plugin = (Plugin)fImport.getPlugin();
            if (plugin.getPluginBase() instanceof Fragment) {
                IFragmentModel[] fragments = PDECore.getDefault().getWorkspaceModelManager().getFragmentModels();
                for (int i = 0; i < fragments.length; ++i) {
                    IFragment fragment = fragments[i].getFragment();
                    if (!fragment.getId().equals(plugin.getId()) || plugin.getVersion() != null && !fragment.getVersion().equals(plugin.getVersion())) continue;
                    plugin.setModel(fragment.getModel());
                    return;
                }
            } else {
                plugin.setModel(PDECore.getDefault().findPlugin(plugin.getId(), plugin.getVersion(), 0).getModel());
            }
        }
    }

    class ImportContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                return ((IFeature)parent).getImports();
            }
            return new Object[0];
        }
    }
}

