/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class JavaAttributeWizard
extends Wizard {
    private String className;
    private String classArgs;
    private IProject project;
    private ISchemaAttribute attInfo;
    private IPluginModelBase model;
    private JavaAttributeWizardPage mainPage;
    private static String STORE_SECTION = "JavaAttributeWizard";

    public JavaAttributeWizard(JavaAttributeValue value) {
        this(value.getProject(), value.getModel(), value.getAttributeInfo(), value.getClassName());
    }

    public JavaAttributeWizard(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        this.className = className;
        this.model = model;
        this.project = project;
        this.attInfo = attInfo;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(PDEPlugin.getResourceString("JavaAttributeWizard.wtitle"));
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public void addPages() {
        this.mainPage = new JavaAttributeWizardPage(this.project, this.model, this.attInfo, this.className);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.init();
    }

    public boolean performFinish() {
        this.className = this.mainPage.getPackageText() != null && this.mainPage.getPackageText().length() > 0 ? this.mainPage.getPackageText() + "." + this.mainPage.getTypeName() : this.mainPage.getTypeName();
        this.classArgs = this.mainPage.getClassArgs();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                JavaAttributeWizard.this.mainPage.createType(monitor);
                IResource resource = JavaAttributeWizard.this.mainPage.getModifiedResource();
                if (resource != null) {
                    JavaAttributeWizard.this.selectAndReveal(resource);
                    if (JavaAttributeWizard.this.project.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jProject = JavaCore.create((IProject)JavaAttributeWizard.this.project);
                        IJavaElement jElement = jProject.findElement(resource.getProjectRelativePath().removeFirstSegments(1));
                        if (jElement != null) {
                            JavaUI.openInEditor((IJavaElement)jElement);
                        }
                    } else if (resource instanceof IFile) {
                        IWorkbenchPage page = PDEPlugin.getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)PDEPlugin.getActiveWorkbenchWindow());
    }

    protected ISchedulingRule getSchedulingRule() {
        return this.mainPage.getModifiedResource();
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNameWithArgs() {
        if (this.classArgs != null && this.classArgs.length() > 0) {
            return this.className + ":" + this.classArgs;
        }
        return this.getClassName();
    }
}

