/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager,
IPDEColorConstants {
    private static Map fColorTable = new HashMap(10);
    private static int counter = 0;

    public ColorManager() {
        this.initialize();
        ++counter;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)IPDEColorConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.instr", (RGB)IPDEColorConstants.PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.string", (RGB)IPDEColorConstants.STRING);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.tag", (RGB)IPDEColorConstants.TAG);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.xml_comment", (RGB)IPDEColorConstants.XML_COMMENT);
    }

    private void initialize() {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
    }

    public void dispose() {
        if (--counter == 0) {
            Iterator e = fColorTable.values().iterator();
            while (e.hasNext()) {
                ((Color)e.next()).dispose();
            }
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        RGB setting = PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property);
        Color color = new Color((Device)Display.getCurrent(), setting);
        fColorTable.put(property, color);
    }

    public Color getColor(String key) {
        Color color = (Color)fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }
}

