/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.CoreUtility;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.schema.DocumentSection;
import org.eclipse.pde.internal.core.schema.EditableSchema;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceSorter;

public abstract class BaseExtensionPointMainPage
extends WizardPage {
    public static final String KEY_PLUGIN_ID = "BaseExtensionPoint.pluginId";
    public static final String KEY_ID = "BaseExtensionPoint.id";
    public static final String KEY_NAME = "BaseExtensionPoint.name";
    public static final String KEY_SCHEMA = "BaseExtensionPoint.schema";
    public static final String KEY_SCHEMA_LOCATION = "BaseExtensionPoint.schemaLocation";
    public static final String KEY_EDIT = "BaseExtensionPoint.edit";
    public static final String KEY_SHARED = "BaseExtensionPoint.shared";
    public static final String KEY_MISSING_ID = "BaseExtensionPoint.missingId";
    public static final String KEY_NO_PLUGIN_MISSING_ID = "BaseExtensionPoint.noPlugin.missingId";
    public static final String KEY_SECTIONS_OVERVIEW = "BaseExtensionPoint.sections.overview";
    public static final String KEY_SECTIONS_SINCE = "BaseExtensionPoint.sections.since";
    public static final String KEY_SECTIONS_USAGE = "BaseExtensionPoint.sections.usage";
    public static final String KEY_GENERATING = "BaseExtensionPoint.generating";
    public static final String KEY_SECTIONS_API = "BaseExtensionPoint.sections.api";
    public static final String KEY_SECTIONS_SUPPLIED = "BaseExtensionPoint.sections.supplied";
    public static final String KEY_SECTIONS_COPYRIGHT = "BaseExtensionPoint.sections.copyright";
    public static final String SETTINGS_PLUGIN_ID = "BaseExtensionPoint.settings.pluginId";
    public static final String SCHEMA_DIR = "schema";
    private IContainer container;
    private IProject project;
    protected Text idText;
    protected Text pluginIdText;
    protected Text nameText;
    protected Text schemaText;
    protected Text schemaLocationText;
    protected Button openSchemaButton;
    protected Button sharedSchemaButton;
    protected Button pluginBrowseButton;
    protected Button findLocationButton;

    public BaseExtensionPointMainPage(IContainer container) {
        super("newExtensionPoint");
        this.container = container;
        this.project = container != null ? container.getProject() : null;
    }

    public void createControl(Composite parent) {
        GridData gd;
        Label label;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        if (this.isPluginIdNeeded()) {
            label = new Label(container, 0);
            label.setText(PDEPlugin.getResourceString(KEY_PLUGIN_ID));
            this.pluginIdText = new Text(container, 2052);
            gd = new GridData(768);
            gd.horizontalSpan = 1;
            gd.widthHint = 275;
            this.pluginIdText.setLayoutData((Object)gd);
            this.pluginIdText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseExtensionPointMainPage.this.validatePage(true);
                }
            });
            this.pluginBrowseButton = new Button(container, 8);
            gd = new GridData(128);
            gd.horizontalSpan = 1;
            gd.widthHint = 50;
            this.pluginBrowseButton.setLayoutData((Object)gd);
            this.pluginBrowseButton.setText(PDEPlugin.getResourceString("BaseExtensionPointMainPage.pluginBrowse"));
            this.pluginBrowseButton.setToolTipText(PDEPlugin.getResourceString("BaseExtensionPointMainPage.pluginId.tooltip"));
            this.pluginBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseExtensionPointMainPage.this.handlePluginBrowse();
                }
            });
            SWTUtil.setButtonDimensionHint(this.pluginBrowseButton);
        }
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_ID));
        this.idText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.idText.setLayoutData((Object)gd);
        this.idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.schemaText.setText(BaseExtensionPointMainPage.this.getSchemaLocation() + "/" + BaseExtensionPointMainPage.this.idText.getText() + ".exsd");
                BaseExtensionPointMainPage.this.validatePage(false);
            }
        });
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NAME));
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.validatePage(false);
            }
        });
        if (this.isPluginIdNeeded() && !this.isPluginIdFinal()) {
            label = new Label(container, 0);
            label.setText(PDEPlugin.getResourceString(KEY_SCHEMA_LOCATION));
            this.schemaLocationText = new Text(container, 2052);
            gd = new GridData(768);
            gd.widthHint = 150;
            gd.grabExcessHorizontalSpace = true;
            this.schemaLocationText.setLayoutData((Object)gd);
            this.schemaLocationText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BaseExtensionPointMainPage.this.validatePage(true);
                }
            });
            this.findLocationButton = new Button(container, 8);
            gd = new GridData(128);
            gd.widthHint = 50;
            this.findLocationButton.setLayoutData((Object)gd);
            this.findLocationButton.setText(PDEPlugin.getResourceString("BaseExtensionPointMainPage.findBrowse"));
            this.findLocationButton.setToolTipText(PDEPlugin.getResourceString("BaseExtensionPointMainPage.schemaLocation.tooltip"));
            this.findLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseExtensionPointMainPage.this.handleSchemaLocation();
                }
            });
            SWTUtil.setButtonDimensionHint(this.findLocationButton);
        }
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_SCHEMA));
        this.schemaText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.schemaText.setLayoutData((Object)gd);
        this.schemaText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseExtensionPointMainPage.this.validatePage(false);
            }
        });
        if (this.isSharedSchemaSwitchNeeded()) {
            this.sharedSchemaButton = new Button(container, 32);
            this.sharedSchemaButton.setText(PDEPlugin.getResourceString(KEY_SHARED));
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.sharedSchemaButton.setLayoutData((Object)gd);
        }
        this.openSchemaButton = new Button(container, 32);
        this.openSchemaButton.setText(PDEPlugin.getResourceString(KEY_EDIT));
        this.openSchemaButton.setSelection(true);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.openSchemaButton.setLayoutData((Object)gd);
        if (this.isPluginIdNeeded()) {
            this.pluginIdText.setFocus();
        } else {
            this.idText.setFocus();
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_schema");
    }

    private InputStream createSchemaStream(String pluginId, String pointId, String name, boolean shared) {
        if (name.length() == 0) {
            name = pointId;
        }
        EditableSchema schema = new EditableSchema(pluginId, pointId, name);
        schema.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_OVERVIEW));
        DocumentSection section = new DocumentSection((ISchemaObject)schema, "since", PDEPlugin.getResourceString("BaseExtensionPointMainPage.since"));
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_SINCE));
        schema.addDocumentSection((IDocumentSection)section);
        if (!shared) {
            SchemaElement element = new SchemaElement((ISchemaObject)schema, "extension");
            SchemaComplexType complexType = new SchemaComplexType((ISchema)schema);
            element.setType((ISchemaType)complexType);
            SchemaCompositor compositor = new SchemaCompositor((ISchemaObject)element, 2);
            complexType.setCompositor((ISchemaCompositor)compositor);
            SchemaAttribute attribute = new SchemaAttribute((ISchemaObject)element, "point");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            attribute.setUse(1);
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "id");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            complexType.addAttribute((ISchemaAttribute)attribute);
            attribute = new SchemaAttribute((ISchemaObject)element, "name");
            attribute.setType((ISchemaSimpleType)new SchemaSimpleType((ISchema)schema, "string"));
            complexType.addAttribute((ISchemaAttribute)attribute);
            schema.addElement((ISchemaElement)element);
        }
        section = new DocumentSection((ISchemaObject)schema, "examples", "Examples");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_USAGE));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "apiInfo", "API Information");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_API));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "implementation", "Supplied Implementation");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_SUPPLIED));
        schema.addDocumentSection((IDocumentSection)section);
        section = new DocumentSection((ISchemaObject)schema, "copyright", "Copyright");
        section.setDescription(PDEPlugin.getResourceString(KEY_SECTIONS_COPYRIGHT));
        schema.addDocumentSection((IDocumentSection)section);
        StringWriter swriter = new StringWriter();
        try {
            PrintWriter writer = new PrintWriter((Writer)swriter, true);
            schema.save(writer);
            swriter.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        try {
            return new ByteArrayInputStream(swriter.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private IFile generateSchemaFile(String pluginId, String id, String name, boolean shared, String schema, IProgressMonitor monitor) throws CoreException {
        IFile schemaFile = null;
        monitor.subTask(PDEPlugin.getResourceString(KEY_GENERATING));
        IWorkspace workspace = this.container.getWorkspace();
        IPath schemaPath = new Path(schema).removeLastSegments(1);
        IPath newSchemaPath = this.container.getProjectRelativePath().append(schemaPath);
        if (!newSchemaPath.isEmpty()) {
            IFolder folder = this.container.getProject().getFolder(newSchemaPath);
            CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
        }
        InputStream source = this.createSchemaStream(pluginId, id, name, shared);
        IPath filePath = this.container.getFullPath().append(schema);
        schemaFile = workspace.getRoot().getFile(filePath);
        if (!schemaFile.exists()) {
            schemaFile.create(source, true, monitor);
        } else {
            schemaFile.setContents(source, true, false, monitor);
        }
        monitor.done();
        IDE.setDefaultEditor((IFile)schemaFile, (String)"org.eclipse.pde.ui.schemaEditor");
        return schemaFile;
    }

    public IRunnableWithProgress getOperation() {
        final boolean openFile = this.openSchemaButton.getSelection();
        final String id = this.idText.getText();
        final String name = this.nameText.getText();
        final String schema = this.schemaText.getText();
        final boolean shared = this.sharedSchemaButton != null ? this.sharedSchemaButton.getSelection() : false;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(IProgressMonitor monitor) {
                try {
                    IFile file;
                    String schemaName = schema;
                    if (!schema.endsWith(".exsd")) {
                        schemaName = schema + ".exsd";
                    }
                    if ((file = BaseExtensionPointMainPage.this.generateSchemaFile(BaseExtensionPointMainPage.this.getPluginId(), id, name, shared, schemaName, monitor)) != null && openFile) {
                        BaseExtensionPointMainPage.this.schemaText.setText(file.getProjectRelativePath().toString());
                        BaseExtensionPointMainPage.this.openSchemaFile(file);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        return operation;
    }

    public String getSchemaLocation() {
        if (this.schemaText != null) {
            String schema = this.schemaText.getText();
            if (schema.length() == 0) {
                return SCHEMA_DIR;
            }
            int loc = schema.lastIndexOf("/");
            if (loc != -1) {
                return schema.substring(0, loc);
            }
        }
        return "";
    }

    public String getPluginId() {
        if (this.pluginIdText != null) {
            return this.pluginIdText.getText();
        }
        return "";
    }

    protected boolean isPluginIdNeeded() {
        return false;
    }

    protected boolean isPluginIdFinal() {
        return false;
    }

    protected boolean isSharedSchemaSwitchNeeded() {
        return false;
    }

    private void openSchemaFile(final IFile file) {
        final IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    String editorId = "org.eclipse.pde.ui.schemaEditor";
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    public boolean checkFieldsFilled() {
        boolean empty;
        boolean bl = empty = this.idText.getText().length() == 0 || this.nameText.getText().length() == 0;
        if (!empty && this.isPluginIdNeeded()) {
            boolean bl2 = empty = this.getPluginId().length() == 0 || this.schemaText.getText().length() == 0;
        }
        if (!empty && !this.isPluginIdFinal()) {
            empty = this.schemaLocationText.getText().length() == 0;
        }
        return !empty;
    }

    private void validatePage(boolean hasContainerChanged) {
        if (hasContainerChanged && !this.validateContainer()) {
            return;
        }
        boolean isComplete = this.checkFieldsFilled();
        this.setPageComplete(isComplete);
        String message = null;
        if (!isComplete) {
            message = this.isPluginIdNeeded() ? PDEPlugin.getResourceString(KEY_MISSING_ID) : PDEPlugin.getResourceString(KEY_NO_PLUGIN_MISSING_ID);
        }
        this.setMessage(message, 2);
    }

    private boolean validateContainer() {
        boolean exists;
        if (this.isPluginIdNeeded() && !this.isPluginIdFinal()) {
            IWorkspaceRoot root;
            IPath workspacePath;
            String newContainerName = this.schemaLocationText.getText();
            if (newContainerName.startsWith((workspacePath = (root = PDECore.getWorkspace().getRoot()).getLocation()).toString())) {
                newContainerName = newContainerName.replaceFirst(workspacePath.toString(), "");
            }
            if (newContainerName.length() == 0) {
                this.handleInvalidContainer();
                return false;
            }
            if (root.exists((IPath)new Path(newContainerName))) {
                this.container = root.getContainerForLocation(workspacePath.append(newContainerName));
            } else if (this.project != null && this.project.exists((IPath)new Path(newContainerName))) {
                this.container = root.getContainerForLocation(this.project.getLocation().append(newContainerName));
            } else {
                this.handleInvalidContainer();
                return false;
            }
            this.handleValidContainer();
            return true;
        }
        boolean bl = exists = this.container != null && this.container.exists();
        if (!exists) {
            this.handleInvalidContainer();
        }
        return exists;
    }

    private void handleInvalidContainer() {
        this.setErrorMessage(PDEPlugin.getResourceString("BaseExtensionPointMainPage.noContainer"));
        this.setPageComplete(false);
    }

    private void handleValidContainer() {
        this.setErrorMessage(null);
    }

    private void handlePluginBrowse() {
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getShell(), PDECore.getDefault().getWorkspaceModelManager().getAllModels(), false);
        dialog.create();
        if (dialog.open() == 0) {
            WorkspacePluginModelBase workspaceModelBase = (WorkspacePluginModelBase)dialog.getFirstResult();
            this.pluginIdText.setText(workspaceModelBase.getPluginBase().getId());
        }
    }

    private void handleSchemaLocation() {
        Object[] elements;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(PDEPlugin.getResourceString("BaseExtensionPointMainPage.schemaLocation.title"));
        dialog.setMessage(PDEPlugin.getResourceString("BaseExtensionPointMainPage.schemaLocation.desc"));
        dialog.setDoubleClickSelects(false);
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    return false;
                }
                if (BaseExtensionPointMainPage.this.isPluginIdFinal()) {
                    return ((IResource)element).getProject().equals(BaseExtensionPointMainPage.this.project);
                }
                return true;
            }
        });
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        dialog.setInitialSelection((Object)this.project);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
            IResource elem = (IResource)elements[0];
            String newPath = this.getWorkspaceRelativePath(elem.getLocation().toString());
            this.schemaLocationText.setText(newPath + "/");
        }
    }

    private String getWorkspaceRelativePath(String path) {
        String workspacePath = PDECore.getWorkspace().getRoot().getLocation().toString();
        if (path.startsWith(workspacePath)) {
            path = path.replaceFirst(workspacePath, "");
        }
        return path;
    }
}

