/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.util.StringMatcher;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PluginImportWizardDetailedPage
extends BaseImportWizardSecondPage {
    private Label countLabel;
    private TableViewer availableListViewer;
    private Text filterText;

    public PluginImportWizardDetailedPage(String pageName, PluginImportWizardFirstPage firstPage) {
        super(pageName, firstPage);
        this.setTitle(PDEPlugin.getResourceString("ImportWizard.DetailedPage.title"));
        this.setMessage(PDEPlugin.getResourceString("ImportWizard.DetailedPage.desc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createScrollArea(container);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createImportList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        Composite options = this.createComputationsOption(container);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        options.setLayoutData((Object)gd);
        this.addViewerListeners();
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private void initialize() {
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.availableListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        this.importListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PluginImportWizardDetailedPage.this.handleFilter();
            }
        });
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.availableList"));
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.widthHint = 225;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        this.availableListViewer = new TableViewer(table);
        this.availableListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.availableListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.availableListViewer.setInput((Object)PDECore.getDefault().getExternalModelManager());
        this.availableListViewer.setSorter(ListUtil.PLUGIN_SORTER);
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 30;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Button button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.existing"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingProjects();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.existingUnshared"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleExistingUnshared();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        new Label(container, 0);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.add"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAdd();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.addAll"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.remove"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemove();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.removeAll"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleRemoveAll();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.swap"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleSwap();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.addRequired"));
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginImportWizardDetailedPage.this.handleAddRequiredPlugins();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        this.countLabel = new Label(comp, 0);
        this.countLabel.setLayoutData((Object)new GridData(64));
        return container;
    }

    private Composite createScrollArea(Composite parent) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        container.setLayoutData((Object)gd);
        container.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.locate"));
        Label filterLabel = new Label((Composite)container, 0);
        filterLabel.setText(PDEPlugin.getResourceString("ImportWizard.DetailedPage.search"));
        this.filterText = new Text((Composite)container, 2048);
        this.filterText.setText("");
        gd = new GridData(768);
        this.filterText.setLayoutData((Object)gd);
        return container;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setPageComplete(visible && this.importListViewer.getTable().getItemCount() > 0);
    }

    protected void refreshPage() {
        this.availableListViewer.refresh();
        this.importListViewer.getTable().removeAll();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.updateCount();
        this.handleFilter();
        this.setPageComplete(this.importListViewer.getTable().getItemCount() > 0);
    }

    private void updateCount() {
        this.countLabel.setText(PDEPlugin.getFormattedMessage("ImportWizard.DetailedPage.count", new String[]{new Integer(this.importListViewer.getTable().getItemCount()).toString(), new Integer(this.models.length).toString()}));
        this.countLabel.getParent().layout();
    }

    private void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.availableListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.availableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.availableListViewer.remove(ssel.toArray());
            this.importListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleAddAll() {
        TableItem[] items = this.availableListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            data.add(items[i].getData());
        }
        if (data.size() > 0) {
            this.importListViewer.add(data.toArray());
            this.availableListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleFilter() {
        if (this.filterText == null || this.filterText.getText().trim().length() == 0) {
            return;
        }
        String text = this.filterText.getText().trim();
        if (text.indexOf(42) == -1 && text.indexOf(63) == -1) {
            text = text + "*";
        }
        StringMatcher stringMatcher = new StringMatcher(text, false, false);
        TableItem[] tableItems = this.availableListViewer.getTable().getItems();
        ArrayList<TableItem> results = new ArrayList<TableItem>();
        for (int i = 0; i < tableItems.length; ++i) {
            IPluginModelBase model;
            Object data = tableItems[i].getData();
            if (!(data instanceof IPluginModelBase) || !stringMatcher.match((model = (IPluginModelBase)data).getPluginBase().getId())) continue;
            results.add(tableItems[i]);
        }
        if (results.size() > 0) {
            TableItem[] selectionList = results.toArray(new TableItem[results.size()]);
            this.availableListViewer.getTable().setSelection(selectionList);
        } else {
            this.availableListViewer.setSelection(null);
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.importListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.importListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.importListViewer.remove(ssel.toArray());
            this.availableListViewer.add(ssel.toArray());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged();
        }
    }

    private void handleRemoveAll() {
        this.handleRemoveAll(true);
    }

    private void handleRemoveAll(boolean refresh) {
        TableItem[] items = this.importListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            data.add(items[i].getData());
        }
        if (data.size() > 0) {
            this.availableListViewer.add(data.toArray());
            this.importListViewer.remove(data.toArray());
            this.pageChanged();
        }
    }

    private void handleSwap() {
        int i;
        TableItem[] aItems = this.availableListViewer.getTable().getItems();
        TableItem[] iItems = this.importListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        for (i = 0; i < iItems.length; ++i) {
            data.add(iItems[i].getData());
        }
        if (data.size() > 0) {
            this.availableListViewer.add(data.toArray());
            this.importListViewer.remove(data.toArray());
        }
        data.clear();
        for (i = 0; i < aItems.length; ++i) {
            data.add(aItems[i].getData());
        }
        if (data.size() > 0) {
            this.importListViewer.add(data.toArray());
            this.availableListViewer.remove(data.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingProjects() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        for (int i = 0; i < this.models.length; ++i) {
            String id = this.models[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project == null || !project.isOpen() || !WorkspaceModelManager.isPluginProject((IProject)project)) continue;
            result.add(this.models[i]);
        }
        if (result.size() > 0) {
            this.importListViewer.add(result.toArray());
            this.availableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleExistingUnshared() {
        this.handleRemoveAll(false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        for (int i = 0; i < this.models.length; ++i) {
            String id = this.models[i].getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project == null || !project.isOpen() || !WorkspaceModelManager.isUnsharedPluginProject((IProject)project)) continue;
            result.add(this.models[i]);
        }
        if (result.size() > 0) {
            this.importListViewer.add(result.toArray());
            this.availableListViewer.remove(result.toArray());
        }
        this.pageChanged();
    }

    private void handleAddRequiredPlugins() {
        IPluginModelBase model;
        TableItem[] items = this.importListViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        if (items.length == 1 && (model = (IPluginModelBase)items[0].getData()).getPluginBase().getId().equals("org.eclipse.core.boot")) {
            return;
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < items.length; ++i) {
            this.addPluginAndDependencies((IPluginModelBase)items[i].getData(), result, this.addFragmentsButton.getSelection());
        }
        this.handleRemoveAll(false);
        this.importListViewer.add(result.toArray());
        this.availableListViewer.remove(result.toArray());
        this.pageChanged();
    }

    class ContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return PluginImportWizardDetailedPage.this.models;
        }
    }
}

