/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class WorkingSetScope
extends AbstractSynchronizeScope
implements IPropertyChangeListener {
    private static final String CTX_SETS = "workingset_scope_sets";
    private static final String CTX_SET_NAME = "workingset_scope_name";
    private IWorkingSet[] sets;

    public WorkingSetScope(IWorkingSet[] sets) {
        this.sets = sets;
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected WorkingSetScope(IMemento memento) {
        super(memento);
    }

    public String getName() {
        if (this.sets.length == 0) {
            return Policy.bind("WorkingSetScope.0");
        }
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < this.sets.length; ++i) {
            IWorkingSet set = this.sets[i];
            name.append(set.getName());
            if (i >= this.sets.length - 1) continue;
            name.append(", ");
        }
        return name.toString();
    }

    public IResource[] getRoots() {
        if (this.sets.length == 0) {
            return null;
        }
        HashSet roots = new HashSet();
        for (int i = 0; i < this.sets.length; ++i) {
            IWorkingSet set = this.sets[i];
            IResource[] resources = Utils.getResources(set.getElements());
            this.addNonOverlapping(roots, resources);
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private void addNonOverlapping(HashSet roots, IResource[] resources) {
        for (int i = 0; i < resources.length; ++i) {
            IResource newResource = resources[i];
            boolean add = true;
            Iterator iter = roots.iterator();
            while (iter.hasNext()) {
                IResource existingResource = (IResource)iter.next();
                if (existingResource.equals(newResource)) {
                    add = false;
                    break;
                }
                if (existingResource.getFullPath().isPrefixOf(newResource.getFullPath())) {
                    add = false;
                    break;
                }
                if (!newResource.getFullPath().isPrefixOf(existingResource.getFullPath())) continue;
                iter.remove();
            }
            if (!add) continue;
            roots.add(newResource);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "workingSetContentChange") {
            IWorkingSet newSet = (IWorkingSet)event.getNewValue();
            for (int i = 0; i < this.sets.length; ++i) {
                IWorkingSet set = this.sets[i];
                if (newSet != set) continue;
                this.fireRootsChanges();
                return;
            }
        }
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        for (int i = 0; i < this.sets.length; ++i) {
            IWorkingSet set = this.sets[i];
            IMemento rootNode = memento.createChild(CTX_SETS);
            rootNode.putString(CTX_SET_NAME, set.getName());
        }
    }

    protected void init(IMemento memento) {
        super.init(memento);
        IMemento[] rootNodes = memento.getChildren(CTX_SETS);
        if (rootNodes != null) {
            ArrayList<IWorkingSet> sets = new ArrayList<IWorkingSet>();
            for (int i = 0; i < rootNodes.length; ++i) {
                IMemento rootNode = rootNodes[i];
                String setName = rootNode.getString(CTX_SET_NAME);
                IWorkingSet set = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setName);
                if (set == null) continue;
                sets.add(set);
            }
            this.sets = sets.toArray(new IWorkingSet[sets.size()]);
        }
    }
}

