/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CodeRefactoringUtil {
    private CodeRefactoringUtil() {
    }

    public static RefactoringStatus checkMethodSyntaxErrors(int selectionStart, int selectionLength, CompilationUnit cuNode, String invalidSelectionMessage) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(selectionStart, selectionLength), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode coveringNode = analyzer.getLastCoveringNode();
        if (!(coveringNode instanceof Block) || !(coveringNode.getParent() instanceof MethodDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        if (ASTNodes.getMessages(coveringNode, 0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)invalidSelectionMessage);
        }
        MethodDeclaration methodDecl = (MethodDeclaration)coveringNode.getParent();
        String[] keys = new String[]{methodDecl.getName().getIdentifier()};
        String message = RefactoringCoreMessages.getFormattedString("CodeRefactoringUtil.error.message", keys);
        return RefactoringStatus.createFatalErrorStatus((String)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIndentationLevel(ASTNode node, IFile file) throws CoreException {
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(file);
            int startLine = buffer.getLineOfOffset(node.getStartPosition());
            int n = buffer.getLineIndent(startLine, CodeFormatterUtil.getTabWidth());
            return n;
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }
}

