/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class SourceAnalyzer {
    private ICompilationUnit fCUnit;
    private MethodDeclaration fDeclaration;
    private Map fParameters;
    private Map fNames;
    private List fImplicitReceivers;
    private List fTypes;
    private boolean fInterruptedExecutionFlow;

    public SourceAnalyzer(ICompilationUnit unit, MethodDeclaration declaration) {
        this.fCUnit = unit;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        this.fParameters = new HashMap(parameters.size() * 2);
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            this.fParameters.put(element.resolveBinding(), element.getProperty(ParameterData.PROPERTY));
        }
        this.fNames = new HashMap();
        this.fImplicitReceivers = new ArrayList(2);
        this.fTypes = new ArrayList(2);
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fInterruptedExecutionFlow;
    }

    public RefactoringStatus checkActivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fCUnit.isStructureKnown()) {
            result.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.syntax_errors"), JavaStatusContext.create(this.fCUnit));
            return result;
        }
        IProblem[] problems = ASTNodes.getProblems((ASTNode)this.fDeclaration, 0, 2);
        if (problems.length > 0) {
            result.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.declaration_has_errors"), JavaStatusContext.create(this.fCUnit, (ASTNode)this.fDeclaration));
            return result;
        }
        if (this.fDeclaration.getBody() == null) {
            result.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.abstract_methods"), JavaStatusContext.create(this.fCUnit, (ASTNode)this.fDeclaration));
            return result;
        }
        ActivationAnalyzer analyzer = new ActivationAnalyzer();
        this.fDeclaration.accept((ASTVisitor)analyzer);
        result.merge(analyzer.status);
        if (!result.hasFatalError()) {
            // empty if block
        }
        return result;
    }

    public void analyzeParameters() {
        Block body = this.fDeclaration.getBody();
        body.accept((ASTVisitor)new UpdateCollector());
        int numberOfLocals = LocalVariableIndex.perform((BodyDeclaration)this.fDeclaration);
        FlowContext context = new FlowContext(0, numberOfLocals + 1);
        context.setConsiderAccessMode(true);
        context.setComputeMode(FlowContext.MERGE);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(context);
        FlowInfo info = flowAnalyzer.perform(this.getStatements());
        Iterator iter = this.fDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            IVariableBinding binding = element.resolveBinding();
            ParameterData data = (ParameterData)element.getProperty(ParameterData.PROPERTY);
            data.setAccessMode(info.getAccessMode(context, binding));
        }
    }

    public Collection getUsedNames() {
        return this.fNames.values();
    }

    public List getImplicitReceivers() {
        return this.fImplicitReceivers;
    }

    public List getUsedTypes() {
        return this.fTypes;
    }

    private ASTNode[] getStatements() {
        List statements = this.fDeclaration.getBody().statements();
        return statements.toArray(new ASTNode[statements.size()]);
    }

    private class UpdateCollector
    extends ASTVisitor {
        private int fTypeCounter;

        private UpdateCollector() {
        }

        public boolean visit(TypeDeclaration node) {
            ITypeBinding superBinding;
            Name superclass;
            if (this.fTypeCounter++ == 0) {
                this.addNameData(node.getName());
            }
            if ((superclass = node.getSuperclass()) != null && (superBinding = ASTNodes.getTypeBinding(superclass)) != null) {
                SourceAnalyzer.this.fTypes.add(superclass);
            }
            List interfaces = node.superInterfaces();
            Iterator iter = interfaces.iterator();
            while (iter.hasNext()) {
                Name element = (Name)iter.next();
                ITypeBinding binding = ASTNodes.getTypeBinding(element);
                if (binding == null) continue;
                SourceAnalyzer.this.fTypes.add(element);
            }
            return true;
        }

        public void endVisit(TypeDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            ++this.fTypeCounter;
            return true;
        }

        public void endVisit(AnonymousClassDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(MethodDeclaration node) {
            if (node.isConstructor()) {
                TypeDeclaration decl = (TypeDeclaration)ASTNodes.getParent((ASTNode)node, 55);
                NameData name = (NameData)SourceAnalyzer.this.fNames.get(decl.getName().resolveBinding());
                if (name != null) {
                    name.addReference(node.getName());
                }
            }
            return true;
        }

        public boolean visit(MethodInvocation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && node.resolveTypeBinding().isLocal()) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            if (this.fTypeCounter == 0) {
                this.addNameData(node.getName());
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.fTypeCounter == 0) {
                this.addNameData(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            ASTNode parent;
            IVariableBinding vb;
            NameData name;
            IBinding binding = node.resolveBinding();
            ParameterData data = (ParameterData)SourceAnalyzer.this.fParameters.get(binding);
            if (data != null) {
                data.addReference((ASTNode)node);
            }
            if ((name = (NameData)SourceAnalyzer.this.fNames.get(binding)) != null) {
                name.addReference(node);
            }
            if (binding instanceof ITypeBinding) {
                QualifiedName parent2;
                ITypeBinding tb = (ITypeBinding)binding;
                SimpleName qName = node;
                while ((parent2 = (QualifiedName)ASTNodes.getParent((ASTNode)qName, 40)) != null && parent2.getQualifier() != qName) {
                    qName = parent2;
                }
                String typeName = null;
                typeName = tb.isArray() ? tb.getElementType().getQualifiedName() : tb.getQualifiedName();
                if (!ASTNodes.asString((ASTNode)qName).equals(typeName)) {
                    SourceAnalyzer.this.fTypes.add(qName);
                }
            } else if (binding instanceof IVariableBinding && (vb = (IVariableBinding)binding).isField() && (parent = node.getParent()) instanceof Statement) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        private void addNameData(SimpleName name) {
            SourceAnalyzer.this.fNames.put(name.resolveBinding(), new NameData(name.getIdentifier()));
        }
    }

    private class ActivationAnalyzer
    extends ASTVisitor {
        public RefactoringStatus status = new RefactoringStatus();
        private ASTNode fLastNode = this.getLastNode();
        private IMethodBinding fBinding = this.getBinding();

        private ActivationAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            if (node != this.fLastNode) {
                SourceAnalyzer.this.fInterruptedExecutionFlow = true;
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(MethodInvocation node) {
            if (this.fBinding != null && this.fBinding == node.getName().resolveBinding() && !this.status.hasFatalError()) {
                this.status.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.recursive_call"));
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null && !this.status.hasFatalError() && !ASTNodes.isLabel(node)) {
                this.status.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.declaration_has_errors"), JavaStatusContext.create(SourceAnalyzer.this.fCUnit, (ASTNode)SourceAnalyzer.this.fDeclaration));
                return false;
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (node.getQualifier() != null) {
                this.status.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.SourceAnalyzer.qualified_this_expressions"), JavaStatusContext.create(SourceAnalyzer.this.fCUnit, (ASTNode)node));
                return false;
            }
            return true;
        }

        private ASTNode getLastNode() {
            List statements = SourceAnalyzer.this.fDeclaration.getBody().statements();
            if (statements.size() == 0) {
                return null;
            }
            return (ASTNode)statements.get(statements.size() - 1);
        }

        private IMethodBinding getBinding() {
            return SourceAnalyzer.this.fDeclaration.resolveBinding();
        }
    }

    public static class NameData {
        private String fName;
        private List fReferences;

        public NameData(String n) {
            this.fName = n;
            this.fReferences = new ArrayList(2);
        }

        public String getName() {
            return this.fName;
        }

        public void addReference(SimpleName ref) {
            this.fReferences.add(ref);
        }

        public List references() {
            return this.fReferences;
        }
    }
}

