/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CreateArguments;
import org.eclipse.ltk.core.refactoring.participants.CreateParticipant;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ResourceModifications {
    private List fCreate;
    private List fDelete;
    private List fMove;
    private List fMoveArguments;
    private IResource fRename;
    private RenameArguments fRenameArguments;

    public void addCreate(IResource create) {
        if (this.fCreate == null) {
            this.fCreate = new ArrayList(2);
        }
        this.fCreate.add(create);
    }

    public void addDelete(IResource delete) {
        if (this.fDelete == null) {
            this.fDelete = new ArrayList(2);
        }
        this.fDelete.add(delete);
    }

    public void addMove(IResource move, MoveArguments arguments) {
        if (this.fMove == null) {
            this.fMove = new ArrayList(2);
            this.fMoveArguments = new ArrayList(2);
        }
        this.fMove.add(move);
        this.fMoveArguments.add(arguments);
    }

    public void setRename(IResource rename, RenameArguments arguments) {
        Assert.isNotNull(rename);
        Assert.isNotNull(arguments);
        this.fRename = rename;
        this.fRenameArguments = arguments;
    }

    public RefactoringParticipant[] getParticipants(RefactoringStatus status, RefactoringProcessor processor, String[] natures, SharableParticipants shared) throws CoreException {
        Iterator iter;
        DeleteArguments arguments;
        ArrayList<Object> result = new ArrayList<Object>(5);
        if (this.fDelete != null) {
            arguments = new DeleteArguments();
            iter = this.fDelete.iterator();
            while (iter.hasNext()) {
                DeleteParticipant[] deletes = ParticipantManager.loadDeleteParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, iter.next(), (DeleteArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(deletes));
            }
        }
        if (this.fCreate != null) {
            arguments = new CreateArguments();
            iter = this.fCreate.iterator();
            while (iter.hasNext()) {
                CreateParticipant[] creates = ParticipantManager.loadCreateParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, iter.next(), (CreateArguments)arguments, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(creates));
            }
        }
        if (this.fMove != null) {
            for (int i = 0; i < this.fMove.size(); ++i) {
                Object element = this.fMove.get(i);
                MoveArguments arguments2 = (MoveArguments)this.fMoveArguments.get(i);
                MoveParticipant[] moves = ParticipantManager.loadMoveParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, element, (MoveArguments)arguments2, (String[])natures, (SharableParticipants)shared);
                result.addAll(Arrays.asList(moves));
            }
        }
        if (this.fRename != null) {
            RenameParticipant[] renames = ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)processor, (Object)this.fRename, (RenameArguments)this.fRenameArguments, (String[])natures, (SharableParticipants)shared);
            result.addAll(Arrays.asList(renames));
        }
        return result.toArray(new RefactoringParticipant[result.size()]);
    }
}

